/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.PrintStream;
import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.values.storable.CSVHeaderInformation;

public class Header {
    private final Entry[] entries;
    public static final Monitor NO_MONITOR = (source, header, from, to) -> {};

    public Header(Entry ... entries) {
        this.entries = entries;
    }

    public Entry[] entries() {
        return this.entries;
    }

    public String toString() {
        return Arrays.toString(this.entries);
    }

    public Header(Header other) {
        this.entries = new Entry[other.entries.length];
        for (int i = 0; i < other.entries.length; ++i) {
            this.entries[i] = new Entry(other.entries[i]);
        }
    }

    public static class PrintingMonitor
    implements Monitor {
        private final PrintStream out;
        private boolean first = true;

        PrintingMonitor(PrintStream out) {
            this.out = out;
        }

        @Override
        public void typeNormalized(String sourceDescription, String name, String fromType, String toType) {
            if (this.first) {
                this.out.println("Type normalization:");
                this.first = false;
            }
            this.out.println(String.format("  Property type of '%s' normalized from '%s' --> '%s' in %s", name, fromType, toType, sourceDescription));
        }
    }

    public static interface Monitor {
        public void typeNormalized(String var1, String var2, String var3, String var4);
    }

    public static class Entry {
        private final String name;
        private final Type type;
        private final Group group;
        private final Extractor<?> extractor;
        private final CSVHeaderInformation optionalParameter;

        public Entry(String name, Type type, Group group, Extractor<?> extractor) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = null;
        }

        public Entry(String name, Type type, Group group, Extractor<?> extractor, CSVHeaderInformation optionalParameter) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = optionalParameter;
        }

        public String toString() {
            if (this.optionalParameter == null) {
                return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() : this.type.name()) + (String)(this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
            }
            return (this.name != null ? this.name : "") + ":" + (String)(this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() + "[" + this.optionalParameter + "]" : this.type.name()) + (String)(this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
        }

        public Extractor<?> extractor() {
            return this.extractor;
        }

        public Type type() {
            return this.type;
        }

        public Group group() {
            return this.group != null ? this.group : Group.GLOBAL;
        }

        public String name() {
            return this.name;
        }

        CSVHeaderInformation optionalParameter() {
            return this.optionalParameter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.name != null) {
                result = 31 * result + this.name.hashCode();
            }
            result = 31 * result + this.type.hashCode();
            if (this.group != null) {
                result = 31 * result + this.group.hashCode();
            }
            result = 31 * result + this.extractor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Entry.nullSafeEquals(this.name, other.name) && this.type == other.type && Entry.nullSafeEquals(this.group, other.group) && Entry.extractorEquals(this.extractor, other.extractor) && Entry.nullSafeEquals(this.optionalParameter, other.optionalParameter);
        }

        Entry(Entry other) {
            this(other.name, other.type, other.group, other.extractor != null ? other.extractor.clone() : null, other.optionalParameter);
        }

        private static boolean nullSafeEquals(Object o1, Object o2) {
            return o1 == null || o2 == null ? o1 == o2 : o1.equals(o2);
        }

        private static boolean extractorEquals(Extractor<?> first, Extractor<?> other) {
            if (first == null || other == null) {
                return first == other;
            }
            return first.getClass().equals(other.getClass());
        }
    }

    public static interface Factory {
        default public Header create(CharSeeker dataSeeker, Configuration configuration, IdType idType, Groups groups) {
            return this.create(dataSeeker, configuration, idType, groups, NO_MONITOR);
        }

        public Header create(CharSeeker var1, Configuration var2, IdType var3, Groups var4, Monitor var5);

        public boolean isDefined();
    }
}

