/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.common.EntityType;

public class IndexConfig {
    public static final IndexConfig DEFAULT = new IndexConfig();
    private boolean createLabelIndex;
    private boolean createRelationTypeIndex;
    private String labelIndexName = "";
    private String relationshipIndexName = "";

    public IndexConfig withLabelIndex() {
        this.createLabelIndex = true;
        return this;
    }

    public IndexConfig withRelationshipTypeIndex() {
        this.createRelationTypeIndex = true;
        return this;
    }

    public IndexConfig withLabelIndex(String name) {
        this.createLabelIndex = true;
        this.labelIndexName = name;
        return this;
    }

    public IndexConfig withRelationshipTypeIndex(String name) {
        this.createRelationTypeIndex = true;
        this.relationshipIndexName = name;
        return this;
    }

    public boolean createLabelIndex() {
        return this.createLabelIndex;
    }

    public boolean createRelationshipIndex() {
        return this.createRelationTypeIndex;
    }

    public String indexName(EntityType entityType) {
        return entityType == EntityType.NODE ? this.labelIndexName : this.relationshipIndexName;
    }

    public static IndexConfig create() {
        return new IndexConfig();
    }
}

