/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.stats;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.helpers.collection.Pair;

public class GenericStatsProvider
implements StatsProvider {
    private final Collection<Pair<Key, Stat>> stats = new ArrayList<Pair<Key, Stat>>();

    public void add(Key key, Stat stat) {
        this.stats.add((Pair<Key, Stat>)Pair.of((Object)key, (Object)stat));
    }

    @Override
    public Stat stat(Key key) {
        for (Pair<Key, Stat> stat1 : this.stats) {
            if (!((Key)stat1.first()).name().equals(key.name())) continue;
            return (Stat)stat1.other();
        }
        return null;
    }

    @Override
    public Key[] keys() {
        Key[] keys = new Key[this.stats.size()];
        int i = 0;
        for (Pair<Key, Stat> stat : this.stats) {
            keys[i++] = (Key)stat.first();
        }
        return keys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Pair<Key, Stat> stat : this.stats) {
            builder.append(builder.length() > 0 ? ", " : "").append(String.format("%s: %s", ((Key)stat.first()).shortName(), stat.other()));
        }
        return builder.toString();
    }
}

