/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.internal.batchimport.input.DuplicateHeaderException;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;

public class DataFactories {
    private static final Supplier<ZoneId> DEFAULT_TIME_ZONE = () -> ZoneOffset.UTC;
    private static final Pattern TYPE_SPEC_AND_OPTIONAL_PARAMETER = Pattern.compile("(?<newTypeSpec>.+?)(?<optionalParameter>\\{.*})?$");

    private DataFactories() {
    }

    public static DataFactory data(final Decorator decorator, final Charset charset, final Path ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("No files specified");
        }
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.individualFiles((Charset)charset, (Path[])files);
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static DataFactory data(final Decorator decorator, final Supplier<CharReadable> readable) {
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.iterator(reader -> reader, (Object[])new CharReadable[]{(CharReadable)readable.get()});
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static Header.Factory defaultFormatNodeFileHeader(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
        return new DefaultNodeFileHeaderParser(defaultTimeZone, normalizeTypes);
    }

    public static Header.Factory defaultFormatNodeFileHeader(boolean normalizeTypes) {
        return DataFactories.defaultFormatNodeFileHeader(DEFAULT_TIME_ZONE, normalizeTypes);
    }

    public static Header.Factory defaultFormatNodeFileHeader() {
        return DataFactories.defaultFormatNodeFileHeader(false);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
        return new DefaultRelationshipFileHeaderParser(defaultTimeZone, normalizeTypes);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader(boolean normalizeTypes) {
        return DataFactories.defaultFormatRelationshipFileHeader(DEFAULT_TIME_ZONE, normalizeTypes);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader() {
        return DataFactories.defaultFormatRelationshipFileHeader(DEFAULT_TIME_ZONE, false);
    }

    public static Header.Entry[] parseHeaderEntries(CharSeeker dataSeeker, Configuration config, IdType idType, Groups groups, Supplier<ZoneId> defaultTimeZone, HeaderEntryFactory entryFactory, Header.Monitor monitor) {
        try {
            Mark mark = new Mark();
            Extractors extractors = new Extractors(config.arrayDelimiter(), config.emptyQuotedStringsAsNull(), config.trimStrings(), defaultTimeZone);
            Extractor<?> idExtractor = CsvInput.idExtractor(idType, extractors);
            char delimiter = config.delimiter();
            ArrayList<Header.Entry> columns = new ArrayList<Header.Entry>();
            int i = 0;
            while (!mark.isEndOfLine() && dataSeeker.seek(mark, (int)delimiter)) {
                String entryString = dataSeeker.tryExtract(mark, extractors.string()) ? (String)extractors.string().value() : null;
                HeaderEntrySpec spec = new HeaderEntrySpec(entryString);
                if (spec.name == null && spec.type == null || spec.type != null && spec.type.equals(Type.IGNORE.name())) {
                    columns.add(new Header.Entry(null, Type.IGNORE, Group.GLOBAL, null, null));
                } else {
                    columns.add(entryFactory.create(dataSeeker.sourceDescription(), i, spec.name, spec.type, spec.groupName, extractors, idExtractor, groups, monitor));
                }
                ++i;
            }
            return columns.toArray(new Header.Entry[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Extractor<?> parsePropertyType(String typeSpec, Extractors extractors) {
        try {
            return extractors.valueOf(typeSpec);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderException("Unable to parse header", e);
        }
    }

    public static Iterable<DataFactory> datas(DataFactory ... factories) {
        return Iterables.iterable((Object[])factories);
    }

    private static Pair<String, String> splitTypeSpecAndOptionalParameter(String typeSpec) {
        String optionalParameter = null;
        String newTypeSpec = typeSpec;
        Matcher matcher = TYPE_SPEC_AND_OPTIONAL_PARAMETER.matcher(typeSpec);
        if (matcher.find()) {
            try {
                newTypeSpec = matcher.group("newTypeSpec");
                optionalParameter = matcher.group("optionalParameter");
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Failed to parse header: '%s'", typeSpec);
                throw new IllegalArgumentException(errorMessage, e);
            }
        }
        return Pair.of((Object)newTypeSpec, optionalParameter);
    }

    private static class DefaultRelationshipFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        DefaultRelationshipFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
            super(defaultTimeZone, false, normalizeTypes, Type.START_ID, Type.END_ID);
        }

        @Override
        protected Header.Entry entry(String sourceDescription, int index, String name, String typeSpec, Group group, Extractors extractors, Extractor<?> idExtractor, Header.Monitor monitor) {
            Extractor<?> extractor;
            Type type;
            PointValue.PointBuilder optionalParameter = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else {
                Pair<String, String> split = DataFactories.splitTypeSpecAndOptionalParameter(typeSpec);
                typeSpec = (String)split.first();
                String optionalParameterString = (String)split.other();
                if (optionalParameterString != null) {
                    if ("Point".equals(typeSpec)) {
                        optionalParameter = PointValue.parseHeaderInformation((CharSequence)optionalParameterString);
                    } else if ("Time".equals(typeSpec) || "DateTime".equals(typeSpec)) {
                        optionalParameter = TemporalValue.parseHeaderInformation((String)optionalParameterString);
                    }
                }
                if (typeSpec.equalsIgnoreCase(Type.START_ID.name())) {
                    type = Type.START_ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.END_ID.name())) {
                    type = Type.END_ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.TYPE.name())) {
                    type = Type.TYPE;
                    extractor = extractors.string();
                } else {
                    if (DefaultRelationshipFileHeaderParser.isRecognizedType(typeSpec)) {
                        throw new HeaderException("Unexpected relationship header type '" + typeSpec + "'");
                    }
                    type = Type.PROPERTY;
                    extractor = this.propertyExtractor(sourceDescription, name, typeSpec, extractors, monitor);
                }
            }
            return new Header.Entry(name, type, group, extractor, (CSVHeaderInformation)optionalParameter);
        }
    }

    private static class DefaultNodeFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        DefaultNodeFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean normalizeTypes) {
            super(defaultTimeZone, true, normalizeTypes, new Type[0]);
        }

        @Override
        protected Header.Entry entry(String sourceDescription, int index, String name, String typeSpec, Group group, Extractors extractors, Extractor<?> idExtractor, Header.Monitor monitor) {
            Extractor<?> extractor;
            Type type;
            PointValue.PointBuilder optionalParameter = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else {
                Pair<String, String> split = DataFactories.splitTypeSpecAndOptionalParameter(typeSpec);
                typeSpec = (String)split.first();
                String optionalParameterString = (String)split.other();
                if (optionalParameterString != null) {
                    if ("Point".equals(typeSpec)) {
                        optionalParameter = PointValue.parseHeaderInformation((CharSequence)optionalParameterString);
                    } else if ("Time".equals(typeSpec) || "DateTime".equals(typeSpec)) {
                        optionalParameter = TemporalValue.parseHeaderInformation((String)optionalParameterString);
                    }
                }
                if (typeSpec.equalsIgnoreCase(Type.ID.name())) {
                    type = Type.ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.LABEL.name())) {
                    type = Type.LABEL;
                    extractor = extractors.stringArray();
                } else {
                    if (DefaultNodeFileHeaderParser.isRecognizedType(typeSpec)) {
                        throw new HeaderException("Unexpected node header type '" + typeSpec + "'");
                    }
                    type = Type.PROPERTY;
                    extractor = this.propertyExtractor(sourceDescription, name, typeSpec, extractors, monitor);
                }
            }
            return new Header.Entry(name, type, group, extractor, (CSVHeaderInformation)optionalParameter);
        }
    }

    static interface HeaderEntryFactory {
        public Header.Entry create(String var1, int var2, String var3, String var4, String var5, Extractors var6, Extractor<?> var7, Groups var8, Header.Monitor var9);
    }

    private static class HeaderEntrySpec {
        private final String name;
        private final String type;
        private final String groupName;

        HeaderEntrySpec(String rawHeaderField) {
            String rawHeaderUntilOptions;
            int typeIndex;
            String name = rawHeaderField;
            String type = null;
            String groupName = null;
            if (rawHeaderField != null && (typeIndex = (rawHeaderUntilOptions = rawHeaderField.split("\\{")[0]).lastIndexOf(58)) != -1) {
                name = typeIndex > 0 ? rawHeaderField.substring(0, typeIndex) : null;
                type = rawHeaderField.substring(typeIndex + 1);
                int groupNameStartIndex = type.indexOf(40);
                if (groupNameStartIndex != -1) {
                    if (!type.endsWith(")")) {
                        throw new IllegalArgumentException("Group specification in '" + rawHeaderField + "' is invalid, format expected to be 'name:TYPE(group)' where TYPE and (group) are optional");
                    }
                    groupName = type.substring(groupNameStartIndex + 1, type.length() - 1);
                    type = type.substring(0, groupNameStartIndex);
                }
            }
            this.name = name;
            this.type = type;
            this.groupName = groupName;
        }
    }

    private static abstract class AbstractDefaultFileHeaderParser
    implements Header.Factory {
        private final Type[] mandatoryTypes;
        private final Supplier<ZoneId> defaultTimeZone;
        private final boolean normalizeTypes;
        private final HeaderEntryFactory entryFactory;

        AbstractDefaultFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean createGroups, boolean normalizeTypes, Type ... mandatoryTypes) {
            this.defaultTimeZone = defaultTimeZone;
            this.normalizeTypes = normalizeTypes;
            this.mandatoryTypes = mandatoryTypes;
            this.entryFactory = (sourceDescription, entryIndex, name, type, groupName, extractors, idExtractor, groups, monitor) -> {
                Group group = createGroups ? groups.getOrCreate(groupName) : groups.get(groupName);
                return this.entry(sourceDescription, entryIndex, name, type, group, extractors, idExtractor, monitor);
            };
        }

        @Override
        public Header create(CharSeeker dataSeeker, Configuration config, IdType idType, Groups groups, Header.Monitor monitor) {
            Header.Entry[] entries = DataFactories.parseHeaderEntries(dataSeeker, config, idType, groups, this.defaultTimeZone, this.entryFactory, monitor);
            this.validateHeader(entries, dataSeeker);
            return new Header(entries);
        }

        private void validateHeader(Header.Entry[] entries, CharSeeker dataSeeker) {
            HashMap<String, Header.Entry> properties = new HashMap<String, Header.Entry>();
            EnumMap<Type, Header.Entry> singletonEntries = new EnumMap<Type, Header.Entry>(Type.class);
            block4: for (Header.Entry entry : entries) {
                switch (entry.type()) {
                    case PROPERTY: {
                        Header.Entry existingPropertyEntry = (Header.Entry)properties.get(entry.name());
                        if (existingPropertyEntry != null) {
                            throw new DuplicateHeaderException(existingPropertyEntry, entry, dataSeeker.sourceDescription());
                        }
                        properties.put(entry.name(), entry);
                        continue block4;
                    }
                    case ID: 
                    case START_ID: 
                    case END_ID: 
                    case TYPE: {
                        Header.Entry existingSingletonEntry = (Header.Entry)singletonEntries.get((Object)entry.type());
                        if (existingSingletonEntry != null) {
                            throw new DuplicateHeaderException(existingSingletonEntry, entry, dataSeeker.sourceDescription());
                        }
                        singletonEntries.put(entry.type(), entry);
                        continue block4;
                    }
                }
            }
            for (Type type : this.mandatoryTypes) {
                if (singletonEntries.containsKey((Object)type)) continue;
                throw new HeaderException(String.format("Missing header of type %s, among entries %s", new Object[]{type, Arrays.toString(entries)}));
            }
        }

        static boolean isRecognizedType(String typeSpec) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(typeSpec)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        Extractor<?> propertyExtractor(String sourceDescription, String name, String typeSpec, Extractors extractors, Header.Monitor monitor) {
            Extractor<?> extractor = DataFactories.parsePropertyType(typeSpec, extractors);
            if (this.normalizeTypes) {
                String fromType = extractor.name();
                Extractor normalized = extractor.normalize();
                if (!normalized.equals(extractor)) {
                    String toType = normalized.name();
                    monitor.typeNormalized(sourceDescription, name, fromType, toType);
                    return normalized;
                }
            }
            return extractor;
        }

        protected abstract Header.Entry entry(String var1, int var2, String var3, String var4, Group var5, Extractors var6, Extractor<?> var7, Header.Monitor var8);
    }
}

