/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeType;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.memory.MemoryTracker;

public class NodeRelationshipCache
implements MemoryStatsVisitor.Visitable,
AutoCloseable {
    private static final int CHUNK_SIZE = 1000000;
    private static final long EMPTY = -1L;
    private static final long MAX_RELATIONSHIP_ID = 0xFFFFFFFFFFFEL;
    static final int MAX_SMALL_COUNT = 0x1FFFFFFE;
    static final long MAX_COUNT = 0x7FFFFFFFFL;
    private static final int ID_SIZE = 6;
    private static final int COUNT_SIZE = 4;
    private static final int ID_AND_COUNT_SIZE = 10;
    private static final int SPARSE_ID_OFFSET = 0;
    private static final int SPARSE_COUNT_OFFSET = 6;
    private static final int DENSE_NODE_CHANGED_MASK = Integer.MIN_VALUE;
    private static final int SPARSE_NODE_CHANGED_MASK = 0x40000000;
    private static final int BIG_COUNT_MASK = 0x20000000;
    private static final int COUNT_FLAGS_MASKS = -536870912;
    private static final int COUNT_MASK = 0x1FFFFFFF;
    private static final int TYPE_SIZE = 3;
    public static final int GROUP_ENTRY_SIZE = 9 + 10 * Direction.values().length;
    private ByteArray array;
    private byte[] chunkChangedArray;
    private final int denseNodeThreshold;
    private final MemoryTracker memoryTracker;
    private final RelGroupCache relGroupCache;
    private long highNodeId;
    private volatile boolean forward = true;
    private final int chunkSize;
    private final NumberArrayFactory arrayFactory;
    private final LongArray bigCounts;
    private final AtomicInteger bigCountsCursor = new AtomicInteger();
    private long numberOfDenseNodes;
    public static final GroupVisitor NO_GROUP_VISITOR = (nodeId, typeId, out, in, loop) -> -1L;

    public NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, MemoryTracker memoryTracker) {
        this(arrayFactory, denseNodeThreshold, 1000000, 0L, memoryTracker);
    }

    NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, int chunkSize, long base, MemoryTracker memoryTracker) {
        this.arrayFactory = arrayFactory;
        this.chunkSize = chunkSize;
        this.denseNodeThreshold = denseNodeThreshold;
        this.memoryTracker = memoryTracker;
        this.bigCounts = arrayFactory.newDynamicLongArray(1000L, 0L, memoryTracker);
        this.relGroupCache = new RelGroupCache(arrayFactory, chunkSize, base, memoryTracker);
    }

    private static byte[] minusOneBytes(int length) {
        byte[] bytes = new byte[length];
        Arrays.fill(bytes, (byte)-1);
        return bytes;
    }

    public long incrementCount(long nodeId) {
        return this.incrementCount(this.array, nodeId, 6);
    }

    public void setCount(long nodeId, long count, int typeId, Direction direction) {
        if (this.isDense(nodeId)) {
            long relGroupId = NodeRelationshipCache.all48Bits(this.array, nodeId, 0);
            this.relGroupCache.setCount(relGroupId, typeId, direction, count);
        } else {
            this.setCount(this.array, nodeId, 6, count);
        }
    }

    private void setCount(ByteArray array, long index, int offset, long count) {
        NodeRelationshipCache.assertValidCount(index, count);
        if (count > 0x1FFFFFFEL) {
            int slot;
            int rawCount = array.getInt(index, offset);
            if (rawCount == -1 || !NodeRelationshipCache.isBigCount(rawCount)) {
                slot = this.bigCountsCursor.getAndIncrement();
                array.setInt(index, offset, 0x20000000 | slot);
            } else {
                slot = NodeRelationshipCache.countValue(rawCount);
            }
            this.bigCounts.set(slot, count);
        } else {
            array.setInt(index, offset, Math.toIntExact(count));
        }
    }

    private static void assertValidCount(long nodeId, long count) {
        if (count > 0x7FFFFFFFFL) {
            throw new IllegalStateException("Tried to increment count of node id " + nodeId + " to " + count + ", which is too big in one single import");
        }
    }

    private static boolean isBigCount(int storedCount) {
        return (storedCount & 0x20000000) != 0;
    }

    public void setNodeCount(long nodeCount) {
        if (nodeCount - 1L > 0x4000000000L) {
            throw new IllegalArgumentException(String.format("Invalid number of nodes %d. Max is %d", nodeCount, 0x4000000000L));
        }
        this.highNodeId = nodeCount;
        this.array = this.arrayFactory.newByteArray(this.highNodeId, NodeRelationshipCache.minusOneBytes(10), this.memoryTracker);
        this.chunkChangedArray = new byte[this.chunkOf(nodeCount) + 1];
    }

    private long getCount(ByteArray array, long index, int offset) {
        int rawCount = array.getInt(index, offset);
        int count = NodeRelationshipCache.countValue(rawCount);
        if (count == 0x1FFFFFFF) {
            return 0L;
        }
        if (NodeRelationshipCache.isBigCount(rawCount)) {
            return this.bigCounts.get(count);
        }
        return count;
    }

    private static int countValue(int rawCount) {
        return rawCount & 0x1FFFFFFF;
    }

    private long incrementCount(ByteArray array, long index, int offset) {
        array = (ByteArray)array.at(index);
        long count = this.getCount(array, index, offset) + 1L;
        this.setCount(array, index, offset, count);
        return count;
    }

    public boolean isDense(long nodeId) {
        return this.isDense(this.array, nodeId);
    }

    private boolean isDense(ByteArray array, long nodeId) {
        if ((long)this.denseNodeThreshold == -1L) {
            return false;
        }
        return this.getCount(array, nodeId, 6) >= (long)this.denseNodeThreshold;
    }

    public long getAndPutRelationship(long nodeId, int typeId, Direction direction, long firstRelId, boolean incrementCount) {
        if (firstRelId > 0xFFFFFFFFFFFEL) {
            throw new IllegalArgumentException("Illegal relationship id, max is 281474976710654");
        }
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long existingId = NodeRelationshipCache.all48Bits(array, nodeId, 0);
        boolean dense = this.isDense(array, nodeId);
        boolean wasChanged = this.markAsChanged(array, nodeId, NodeRelationshipCache.changeMask(dense));
        this.markChunkAsChanged(nodeId, dense);
        if (dense) {
            if (existingId == -1L) {
                existingId = this.relGroupCache.allocate(typeId);
                NodeRelationshipCache.setRelationshipId(array, nodeId, existingId);
            }
            return this.relGroupCache.getAndPutRelationship(existingId, typeId, direction, firstRelId, incrementCount);
        }
        NodeRelationshipCache.setRelationshipId(array, nodeId, firstRelId);
        return wasChanged ? -1L : existingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markChunkAsChanged(long nodeId, boolean dense) {
        int chunk;
        byte mask = NodeRelationshipCache.chunkChangeMask(dense);
        if (this.chunkHasChange(nodeId, mask) || (this.chunkChangedArray[chunk = this.chunkOf(nodeId)] & mask) != 0) return;
        byte[] byArray = this.chunkChangedArray;
        synchronized (this.chunkChangedArray) {
            int n = chunk;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] | mask);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    long calculateNumberOfDenseNodes() {
        long count = 0L;
        for (long i = 0L; i < this.highNodeId; ++i) {
            if (!this.isDense(i)) continue;
            ++count;
        }
        return count;
    }

    private int chunkOf(long nodeId) {
        return Math.toIntExact(nodeId / (long)this.chunkSize);
    }

    private static byte chunkChangeMask(boolean dense) {
        return (byte)(1 << (dense ? 1 : 0));
    }

    private boolean markAsChanged(ByteArray array, long nodeId, int mask) {
        boolean changeBitWasFlipped;
        int bits = array.getInt(nodeId, 6);
        boolean changeBitIsSet = (bits & mask) != 0;
        boolean bl = changeBitWasFlipped = changeBitIsSet != this.forward;
        if (changeBitWasFlipped) {
            array.setInt(nodeId, 6, bits ^= mask);
        }
        return changeBitWasFlipped;
    }

    private boolean nodeIsChanged(ByteArray array, long nodeId, long mask) {
        int bits = array.getInt(nodeId, 6);
        if (bits == -1) {
            return false;
        }
        boolean changeBitIsSet = ((long)bits & mask) != 0L;
        return changeBitIsSet == this.forward;
    }

    private static void setRelationshipId(ByteArray array, long nodeId, long firstRelId) {
        array.set6ByteLong(nodeId, 0, firstRelId);
    }

    private static long getRelationshipId(ByteArray array, long nodeId) {
        return array.get6ByteLong(nodeId, 0);
    }

    private static long all48Bits(ByteArray array, long index, int offset) {
        return NodeRelationshipCache.all48Bits(array.get6ByteLong(index, offset));
    }

    private static long all48Bits(long raw) {
        return raw == -1L ? raw : raw & 0xFFFFFFFFFFFFL;
    }

    public long getFirstRel(long nodeId, GroupVisitor visitor) {
        assert (this.forward) : "This should only be done at forward scan";
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long id = NodeRelationshipCache.getRelationshipId(array, nodeId);
        if (id != -1L && this.isDense(array, nodeId)) {
            return this.relGroupCache.visitGroup(nodeId, id, visitor);
        }
        return id;
    }

    public void setForwardScan(boolean forward, boolean denseNodes) {
        if (this.forward == forward) {
            return;
        }
        if (denseNodes) {
            if (forward) {
                this.visitChangedNodes((nodeId, array) -> NodeRelationshipCache.setRelationshipId(array, nodeId, -1L), 1);
                this.clearChangedChunks(true);
                this.relGroupCache.clear();
            } else {
                this.relGroupCache.clearRelationshipIds();
            }
        }
        this.forward = forward;
    }

    public long getCount(long nodeId, int typeId, Direction direction) {
        ByteArray array = (ByteArray)this.array.at(nodeId);
        boolean dense = this.isDense(array, nodeId);
        if (dense) {
            long id = NodeRelationshipCache.getRelationshipId(array, nodeId);
            return id == -1L ? 0L : this.relGroupCache.getAndResetCount(id, typeId, direction);
        }
        return this.getCount(array, nodeId, 6);
    }

    public String toString() {
        return this.array.toString();
    }

    @Override
    public void close() {
        if (this.array != null) {
            this.array.close();
        }
        if (this.relGroupCache != null) {
            this.relGroupCache.close();
        }
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        NodeRelationshipCache.nullSafeMemoryStatsVisitor(this.array, visitor);
        this.relGroupCache.acceptMemoryStatsVisitor(visitor);
    }

    static void nullSafeMemoryStatsVisitor(MemoryStatsVisitor.Visitable visitable, MemoryStatsVisitor visitor) {
        if (visitable != null) {
            visitable.acceptMemoryStatsVisitor(visitor);
        }
    }

    private static int changeMask(boolean dense) {
        return dense ? Integer.MIN_VALUE : 0x40000000;
    }

    public void visitChangedNodes(NodeChangeVisitor visitor, int nodeTypes) {
        long denseMask = NodeRelationshipCache.changeMask(true);
        long sparseMask = NodeRelationshipCache.changeMask(false);
        byte denseChunkMask = NodeRelationshipCache.chunkChangeMask(true);
        byte sparseChunkMask = NodeRelationshipCache.chunkChangeMask(false);
        long nodeId = 0L;
        while (nodeId < this.highNodeId) {
            boolean nodeHasChanged;
            boolean chunkHasChanged;
            boolean bl = chunkHasChanged = NodeType.isDense(nodeTypes) && this.chunkHasChange(nodeId, denseChunkMask) || NodeType.isSparse(nodeTypes) && this.chunkHasChange(nodeId, sparseChunkMask);
            if (!chunkHasChanged) {
                nodeId += (long)this.chunkSize;
                continue;
            }
            boolean bl2 = nodeHasChanged = NodeType.isDense(nodeTypes) && this.nodeIsChanged(this.array, nodeId, denseMask) || NodeType.isSparse(nodeTypes) && this.nodeIsChanged(this.array, nodeId, sparseMask);
            if (nodeHasChanged && NodeType.matchesDense(nodeTypes, this.isDense(this.array, nodeId))) {
                visitor.change(nodeId, this.array);
            }
            ++nodeId;
        }
    }

    private void clearChangedChunks(boolean denseNodes) {
        byte chunkMask = NodeRelationshipCache.chunkChangeMask(denseNodes);
        int i = 0;
        while (i < this.chunkChangedArray.length) {
            int n = i++;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] & ~chunkMask);
        }
    }

    private boolean chunkHasChange(long nodeId, byte chunkMask) {
        int chunkId = this.chunkOf(nodeId);
        return (this.chunkChangedArray[chunkId] & chunkMask) != 0;
    }

    public long calculateMaxMemoryUsage(long numberOfRelationships) {
        return NodeRelationshipCache.calculateMaxMemoryUsage(this.numberOfDenseNodes, numberOfRelationships);
    }

    public static long calculateMaxMemoryUsage(long numberOfDenseNodes, long numberOfRelationships) {
        long maxDenseNodesForThisType = Long.min(numberOfDenseNodes, numberOfRelationships * 2L);
        return maxDenseNodesForThisType * (long)GROUP_ENTRY_SIZE;
    }

    public void countingCompleted() {
        this.numberOfDenseNodes = this.calculateNumberOfDenseNodes();
    }

    public long getNumberOfDenseNodes() {
        return this.numberOfDenseNodes;
    }

    public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
        return visitor -> visitor.offHeapUsage(10L * numberOfNodes);
    }

    @FunctionalInterface
    public static interface NodeChangeVisitor {
        public void change(long var1, ByteArray var3);
    }

    private class RelGroupCache
    implements AutoCloseable,
    MemoryStatsVisitor.Visitable {
        private static final int TYPE_OFFSET = 0;
        private static final int NEXT_OFFSET = 3;
        private static final int BASE_IDS_OFFSET = 9;
        private final byte[] DEFAULT_VALUE = NodeRelationshipCache.minusOneBytes(GROUP_ENTRY_SIZE);
        private final long chunkSize;
        private final long base;
        private final ByteArray array;
        private final AtomicLong nextFreeId;

        RelGroupCache(NumberArrayFactory arrayFactory, long chunkSize, long base, MemoryTracker memoryTracker) {
            this.chunkSize = chunkSize;
            this.base = base;
            assert (chunkSize > 0L);
            this.array = arrayFactory.newDynamicByteArray(chunkSize, this.DEFAULT_VALUE, memoryTracker);
            this.nextFreeId = new AtomicLong(base);
        }

        private void clearIndex(ByteArray array, long relGroupId) {
            array.set(relGroupId, this.DEFAULT_VALUE);
        }

        long getAndResetCount(long relGroupIndex, int typeId, Direction direction) {
            long index = this.rebase(relGroupIndex);
            while (index != -1L) {
                ByteArray array = (ByteArray)this.array.at(index);
                if (this.getTypeId(array, index) == typeId) {
                    int offset = this.countOffset(direction);
                    long count = NodeRelationshipCache.this.getCount(array, index, offset);
                    NodeRelationshipCache.this.setCount(array, index, offset, 0L);
                    return count;
                }
                index = this.getNext(array, index);
            }
            return 0L;
        }

        void setCount(long relGroupIndex, int typeId, Direction direction, long count) {
            long index = this.rebase(relGroupIndex);
            while (index != -1L) {
                ByteArray array = (ByteArray)this.array.at(index);
                if (this.getTypeId(array, index) == typeId) {
                    NodeRelationshipCache.this.setCount(array, index, this.countOffset(direction), count);
                    break;
                }
                index = this.getNext(array, index);
            }
        }

        long getNext(ByteArray array, long index) {
            return NodeRelationshipCache.all48Bits(array, index, 3);
        }

        int getTypeId(ByteArray array, long index) {
            return array.get3ByteInt(index, 0);
        }

        private long rebase(long index) {
            return index - this.base;
        }

        private long nextFreeId() {
            return this.nextFreeId.getAndIncrement();
        }

        private long visitGroup(long nodeId, long relGroupIndex, GroupVisitor visitor) {
            long currentIndex = this.rebase(relGroupIndex);
            long first = -1L;
            while (currentIndex != -1L) {
                long nextId;
                ByteArray array = (ByteArray)this.array.at(currentIndex);
                long out = NodeRelationshipCache.all48Bits(array, currentIndex, this.idOffset(Direction.OUTGOING));
                int typeId = this.getTypeId(array, currentIndex);
                long in = NodeRelationshipCache.all48Bits(array, currentIndex, this.idOffset(Direction.INCOMING));
                long loop = NodeRelationshipCache.all48Bits(array, currentIndex, this.idOffset(Direction.BOTH));
                long next = this.getNext(array, currentIndex);
                long l = nextId = out == -1L && in == -1L && loop == -1L ? -1L : visitor.visit(nodeId, typeId, out, in, loop);
                if (first == -1L) {
                    first = nextId;
                }
                currentIndex = next;
            }
            return first;
        }

        private int idOffset(Direction direction) {
            return 9 + direction.ordinal() * 10;
        }

        private int countOffset(Direction direction) {
            return this.idOffset(direction) + 6;
        }

        long allocate(int typeId) {
            long index = this.nextFreeId();
            long rebasedIndex = this.rebase(index);
            ByteArray array = (ByteArray)this.array.at(rebasedIndex);
            this.clearIndex(array, rebasedIndex);
            array.set3ByteInt(rebasedIndex, 0, Numbers.safeCheck3ByteInt((int)typeId));
            return index;
        }

        private long getAndPutRelationship(long relGroupIndex, int typeId, Direction direction, long relId, boolean incrementCount) {
            long index = this.rebase(relGroupIndex);
            index = this.findOrAllocateIndex(index, typeId);
            ByteArray array = (ByteArray)this.array.at(index);
            int directionOffset = this.idOffset(direction);
            long previousId = NodeRelationshipCache.all48Bits(array, index, directionOffset);
            array.set6ByteLong(index, directionOffset, relId);
            if (incrementCount) {
                NodeRelationshipCache.this.incrementCount(array, index, this.countOffset(direction));
            }
            return previousId;
        }

        private void clearRelationshipIds(ByteArray array, long index) {
            array.set6ByteLong(index, this.idOffset(Direction.OUTGOING), -1L);
            array.set6ByteLong(index, this.idOffset(Direction.INCOMING), -1L);
            array.set6ByteLong(index, this.idOffset(Direction.BOTH), -1L);
        }

        private long findOrAllocateIndex(long index, int typeId) {
            long lastIndex = index;
            ByteArray array = (ByteArray)this.array.at(index);
            while (index != -1L) {
                lastIndex = index;
                array = (ByteArray)this.array.at(index);
                int candidateTypeId = this.getTypeId(array, index);
                if (candidateTypeId == typeId) {
                    return index;
                }
                index = this.getNext(array, index);
            }
            long newIndex = this.allocate(typeId);
            array.set6ByteLong(lastIndex, 3, newIndex);
            return newIndex;
        }

        @Override
        public void close() {
            if (this.array != null) {
                this.array.close();
            }
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
            NodeRelationshipCache.nullSafeMemoryStatsVisitor(this.array, visitor);
        }

        public void clear() {
            this.nextFreeId.set(this.base);
        }

        public void clearRelationshipIds() {
            long highId = this.rebase(this.nextFreeId.get());
            long i = 0L;
            while (i < highId) {
                ByteArray chunk = (ByteArray)this.array.at(i);
                int j = 0;
                while ((long)j < this.chunkSize && i < highId) {
                    this.clearRelationshipIds(chunk, i);
                    ++j;
                    ++i;
                }
            }
        }
    }

    public static interface GroupVisitor {
        public long visit(long var1, int var3, long var4, long var6, long var8);
    }
}

