/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public abstract class PageCacheNumberArray<N extends NumberArray<N>>
implements NumberArray<N> {
    private static final String PAGE_CACHE_WORKER_TAG = "pageCacheNumberArrayWorker";
    protected final PagedFile pagedFile;
    protected final int entriesPerPage;
    protected final PageCacheTracer pageCacheTracer;
    protected final int entrySize;
    private final long length;
    private final long defaultValue;
    private final long base;
    private boolean closed;

    PageCacheNumberArray(PagedFile pagedFile, PageCacheTracer pageCacheTracer, int entrySize, long length, long base) throws IOException {
        this(pagedFile, pageCacheTracer, entrySize, length, 0L, base);
    }

    PageCacheNumberArray(PagedFile pagedFile, PageCacheTracer pageCacheTracer, int entrySize, long length, long defaultValue, long base) throws IOException {
        this.pagedFile = pagedFile;
        this.pageCacheTracer = pageCacheTracer;
        this.entrySize = entrySize;
        this.entriesPerPage = pagedFile.pageSize() / entrySize;
        this.length = length;
        this.defaultValue = defaultValue;
        this.base = base;
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(PAGE_CACHE_WORKER_TAG);
             PageCursor cursorToSetLength = pagedFile.io(0L, 2, cursorTracer);){
            this.setLength(cursorToSetLength, length);
        }
        if (defaultValue != 0L) {
            this.setDefaultValue(defaultValue);
        }
    }

    private void setLength(PageCursor cursor, long length) throws IOException {
        if (!cursor.next((length - 1L) / (long)this.entriesPerPage)) {
            throw new IllegalStateException(String.format("Unable to extend the backing file %s to desired size %d.", this.pagedFile, length));
        }
    }

    protected long pageId(long index) {
        return this.rebase(index) / (long)this.entriesPerPage;
    }

    protected int offset(long index) {
        return Math.toIntExact(this.rebase(index) % (long)this.entriesPerPage * (long)this.entrySize);
    }

    private long rebase(long index) {
        return index - this.base;
    }

    protected void setDefaultValue(long defaultValue) throws IOException {
        block19: {
            try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(PAGE_CACHE_WORKER_TAG);
                 PageCursor writeCursor = this.pagedFile.io(0L, 6, cursorTracer);){
                writeCursor.next();
                int pageSize = this.pagedFile.pageSize();
                this.fillPageWithDefaultValue(writeCursor, defaultValue, pageSize);
                if (this.pageId(this.length - 1L) <= 0L) break block19;
                try (PageCursor cursor = this.pagedFile.io(1L, 6, cursorTracer);){
                    while (cursor.next()) {
                        writeCursor.copyTo(0, cursor, 0, pageSize);
                        this.checkBounds(writeCursor);
                    }
                }
            }
        }
    }

    protected void fillPageWithDefaultValue(PageCursor writeCursor, long defaultValue, int pageSize) {
        int longsInPage = pageSize / 8;
        for (int i = 0; i < longsInPage; ++i) {
            writeCursor.putLong(defaultValue);
        }
        this.checkBounds(writeCursor);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void clear() {
        try {
            this.setDefaultValue(this.defaultValue);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.pagedFile.close();
        this.closed = true;
    }

    @Override
    public N at(long index) {
        return (N)this;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length() * (long)this.entrySize);
    }

    protected void checkBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new IllegalStateException(String.format("Cursor %s access out of bounds, page id %d, offset %d", cursor, cursor.getCurrentPageId(), cursor.getOffset()));
        }
    }
}

