/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.os.OsBeanUtil;

public interface Configuration {
    public static final long MAX_PAGE_CACHE_MEMORY = ByteUnit.gibiBytes((long)1L);
    public static final int DEFAULT_MAX_MEMORY_PERCENT = 90;
    public static final Configuration DEFAULT = new Configuration(){};

    default public int batchSize() {
        return 10000;
    }

    default public int movingAverageSize() {
        return 100;
    }

    default public int maxNumberOfProcessors() {
        return Configuration.allAvailableProcessors();
    }

    public static int allAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    default public long pageCacheMemory() {
        long maxFreeMemory = OsBeanUtil.getFreePhysicalMemory();
        if (0L < maxFreeMemory && maxFreeMemory < Long.MAX_VALUE) {
            return Math.min(MAX_PAGE_CACHE_MEMORY, maxFreeMemory);
        }
        return MAX_PAGE_CACHE_MEMORY;
    }

    default public long maxMemoryUsage() {
        return Configuration.calculateMaxMemoryFromPercent(90);
    }

    default public boolean sequentialBackgroundFlushing() {
        return true;
    }

    default public boolean parallelRecordWrites() {
        return true;
    }

    default public boolean parallelRecordReads() {
        return true;
    }

    default public boolean highIO() {
        return false;
    }

    default public boolean allowCacheAllocationOnHeap() {
        return false;
    }

    public static Configuration withBatchSize(Configuration config, final int batchSize) {
        return new Overridden(config){

            @Override
            public int batchSize() {
                return batchSize;
            }
        };
    }

    public static boolean canDetectFreeMemory() {
        return OsBeanUtil.getFreePhysicalMemory() != -1L;
    }

    public static long calculateMaxMemoryFromPercent(int percent) {
        long halfPhysicalMemory;
        if (percent < 1) {
            throw new IllegalArgumentException("Expected percentage to be > 0, was " + percent);
        }
        if (percent > 100) {
            throw new IllegalArgumentException("Expected percentage to be < 100, was " + percent);
        }
        long totalPhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        if (totalPhysicalMemory == -1L) {
            return ByteUnit.gibiBytes((long)2L);
        }
        double factor = (double)percent / 100.0;
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        if (jvmMaxMemory > (halfPhysicalMemory = totalPhysicalMemory / 2L)) {
            jvmMaxMemory = halfPhysicalMemory;
        }
        long availableMemory = totalPhysicalMemory - jvmMaxMemory;
        return Math.round((double)availableMemory * factor);
    }

    public static class Overridden
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public Overridden(Configuration defaults) {
            this(defaults, Config.defaults());
        }

        public Overridden(Configuration defaults, Config config) {
            this.defaults = defaults;
            this.config = config;
        }

        public Overridden(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public long pageCacheMemory() {
            String pageCacheMemory = (String)this.config.get(GraphDatabaseSettings.pagecache_memory);
            if (pageCacheMemory == null) {
                return this.defaults.pageCacheMemory();
            }
            return Math.min(MAX_PAGE_CACHE_MEMORY, ByteUnit.parse((String)pageCacheMemory));
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }

        @Override
        public boolean sequentialBackgroundFlushing() {
            return this.defaults.sequentialBackgroundFlushing();
        }

        @Override
        public int batchSize() {
            return this.defaults.batchSize();
        }

        @Override
        public int maxNumberOfProcessors() {
            return this.defaults.maxNumberOfProcessors();
        }

        @Override
        public boolean parallelRecordWrites() {
            return this.defaults.parallelRecordWrites();
        }

        @Override
        public boolean parallelRecordReads() {
            return this.defaults.parallelRecordReads();
        }

        @Override
        public boolean highIO() {
            return this.defaults.highIO();
        }

        @Override
        public long maxMemoryUsage() {
            return this.defaults.maxMemoryUsage();
        }

        @Override
        public boolean allowCacheAllocationOnHeap() {
            return this.defaults.allowCacheAllocationOnHeap();
        }
    }
}

