/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.nio.file.Path;
import java.time.ZoneId;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;

record ParquetData(Set<String> labelsOrType, Path file, List<ParquetColumn> columns, Supplier<ZoneId> defaultTimezoneSupplier, String groupName, String relationshipStartIdGroupName, String relationshipEndIdGroupName) {
    ParquetData(Set<String> labelsOrType, Path file, List<ParquetColumn> columns, Supplier<ZoneId> defaultTimezoneSupplier) {
        this(labelsOrType, file, columns, defaultTimezoneSupplier, ParquetData.findColumnGroupName(columns, ParquetColumn::isIdColumn), ParquetData.findColumnGroupName(columns, ParquetColumn::isStartId), ParquetData.findColumnGroupName(columns, ParquetColumn::isEndId));
    }

    private static String findColumnGroupName(List<ParquetColumn> columns, Predicate<ParquetColumn> filter) {
        for (ParquetColumn column : columns) {
            if (!filter.test(column)) continue;
            return column.groupName();
        }
        return null;
    }
}

