/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.function.Factory;
import org.neo4j.internal.batchimport.cache.idmapping.string.RadixCalculator;

public abstract class Radix {
    public static final Factory<Radix> LONG = LongRadix::new;
    public static final Factory<Radix> STRING = StringRadix::new;
    private final LongAdder nullCount = new LongAdder();
    final AtomicLongArray radixIndexCount = new AtomicLongArray((int)Math.pow(2.0, 23.0));

    public void preRegisterRadixOf(long value) {
    }

    public void registerRadixOf(long value) {
        int radix = this.calculator().radixOf(value);
        if (radix == -1) {
            this.nullCount.add(1L);
        } else {
            this.radixIndexCount.incrementAndGet(radix);
        }
    }

    public long getNullCount() {
        return this.nullCount.sum();
    }

    public long[] getRadixIndexCounts() {
        long[] array = new long[this.radixIndexCount.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.radixIndexCount.get(i);
        }
        return array;
    }

    public abstract RadixCalculator calculator();

    public String toString() {
        return Radix.class.getSimpleName() + "." + this.getClass().getSimpleName();
    }

    public static class LongRadix
    extends Radix {
        private volatile int radixShift;
        private final RadixCalculator calculator = new RadixCalculator.LongRadixCalculator(() -> this.radixShift);

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preRegisterRadixOf(long val) {
            long shiftVal = (val & 0x1FFFFFFFFFFFFFFL) >> 23 + this.radixShift;
            if (shiftVal > 0L) {
                LongRadix longRadix = this;
                synchronized (longRadix) {
                    for (shiftVal = (val & 0x1FFFFFFFFFFFFFFL) >> 23 + this.radixShift; shiftVal > 0L; shiftVal >>= 1) {
                        ++this.radixShift;
                    }
                }
            }
        }
    }

    public static class StringRadix
    extends Radix {
        private final RadixCalculator calculator = new RadixCalculator.StringRadixCalculator();

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }
    }
}

