/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;

public class BackgroundFlusher
implements AutoCloseable {
    private volatile boolean enabled;
    private volatile boolean halted;
    private volatile boolean singleFlush;
    private final Thread flusher = new Thread(() -> {
        while (!this.halted) {
            try {
                if (!this.enabled) {
                    Thread.sleep(100L);
                    continue;
                }
                long end = System.currentTimeMillis() + frequencyMillis;
                for (int i = 0; i < 100 && System.currentTimeMillis() < end && this.enabled && !this.halted; ++i) {
                    Thread.sleep(100L);
                }
                if (!this.enabled || this.halted) continue;
                boolean singleFlush = this.singleFlush;
                this.singleFlush = false;
                pageCache.flush(DatabaseFlushEvent.NULL);
                if (!singleFlush) continue;
                this.enabled = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    });

    public BackgroundFlusher(PageCache pageCache, long frequencyMillis) {
        this.flusher.start();
    }

    public void enable() {
        this.enabled = true;
    }

    public void enableSingle() {
        this.singleFlush = true;
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    @Override
    public void close() {
        this.halted = true;
        try {
            this.flusher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

