/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.helpers.collection.Iterables;

class IdValueBuilder {
    private final List<Part> parts = new ArrayList<Part>();
    private Group group;

    IdValueBuilder() {
    }

    void clear() {
        this.parts.clear();
        this.group = null;
    }

    void part(Object value, Header.Entry entry) {
        if (this.group != null && !entry.group().equals((Object)this.group)) {
            throw new IllegalStateException("Multiple ID columns for different groups:" + String.valueOf(this.group) + " and " + String.valueOf(entry.group()));
        }
        this.parts.add(new Part(entry.name(), value));
        this.group = entry.group();
    }

    Object value() {
        return switch (this.parts.size()) {
            case 0 -> null;
            case 1 -> this.parts.get((int)0).value;
            default -> {
                StringBuilder result = new StringBuilder();
                for (Part part : this.parts) {
                    result.append(part.value);
                }
                yield result.toString();
            }
        };
    }

    Group group() {
        return this.group;
    }

    Iterable<Part> idPropertyValues() {
        return Iterables.filter(this.parts, p -> p.name != null);
    }

    boolean isEmpty() {
        return this.parts.isEmpty();
    }

    record Part(String name, Object value) {
    }
}

