/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.ByteBuffer;
import org.neo4j.internal.batchimport.cache.BaseDynamicArray;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.memory.MemoryTracker;

class ByteArrayImpl
extends BaseDynamicArray
implements ByteArray {
    ByteArrayImpl(long maxNumberOfElements, int elementSize, int elementsPerChunk, byte defaultValue, BufferFactory bufferFactory, MemoryTracker memoryTracker) {
        super(maxNumberOfElements, elementSize, elementsPerChunk, defaultValue, bufferFactory, memoryTracker);
    }

    @Override
    public void get(long index, byte[] into) {
        int batch;
        int length = into.length;
        int offset = this.offset(index);
        for (int intoOffset = 0; intoOffset < length; intoOffset += batch) {
            ByteBuffer buffer = this.getBuffer(index + (long)intoOffset);
            batch = Math.min(length - intoOffset, buffer.capacity() - offset);
            buffer.get(offset, into, intoOffset, batch);
            offset = 0;
        }
    }

    @Override
    public void getElement(long index, byte[] into) {
        assert (into.length == this.elementSize) : "Destination must match elementSize";
        this.getBuffer(index).get(this.offset(index), into, 0, into.length);
    }

    @Override
    public byte getByte(long index, int additionalOffset) {
        return this.getBuffer(index).get(this.offset(index) + additionalOffset);
    }

    @Override
    public short getShort(long index, int additionalOffset) {
        return this.getBuffer(index).getShort(this.offset(index) + additionalOffset);
    }

    @Override
    public int get3ByteInt(long index, int additionalOffset) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        int lsb = b.getShort(o) & 0xFFFF;
        int msb = b.get(o + 2) & 0xFF;
        return ByteArrayImpl.signExtension(lsb | msb << 16, -8388608);
    }

    @Override
    public int getInt(long index, int additionalOffset) {
        return this.getBuffer(index).getInt(this.offset(index) + additionalOffset);
    }

    @Override
    public long get5ByteLong(long index, int additionalOffset) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        long lsb = (long)b.getInt(o) & 0xFFFFFFFFL;
        long msb = (long)b.get(o + 4) & 0xFFL;
        return ByteArrayImpl.signExtension(lsb | msb << 32, -549755813888L);
    }

    @Override
    public long get6ByteLong(long index, int additionalOffset) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        long lsb = (long)b.getInt(o) & 0xFFFFFFFFL;
        long msb = (long)b.getShort(o + 4) & 0xFFFFL;
        return ByteArrayImpl.signExtension(lsb | msb << 32, -140737488355328L);
    }

    @Override
    public long getLong(long index, int additionalOffset) {
        return this.getBuffer(index).getLong(this.offset(index) + additionalOffset);
    }

    @Override
    public void set(long index, byte[] value) {
        int batch;
        int length = value.length;
        int offset = this.offset(index);
        for (int sourceIndex = 0; sourceIndex < length; sourceIndex += batch) {
            ByteBuffer buffer = this.getBuffer(index + (long)sourceIndex);
            batch = Math.min(length - sourceIndex, buffer.capacity() - offset);
            buffer.put(offset, value, sourceIndex, batch);
            offset = 0;
        }
    }

    @Override
    public void setElement(long index, byte[] value) {
        assert (value.length == this.elementSize) : "Value must match elementSize";
        this.getBuffer(index).put(this.offset(index), value);
    }

    @Override
    public void setByte(long index, int additionalOffset, byte value) {
        this.getBuffer(index).put(this.offset(index) + additionalOffset, value);
    }

    @Override
    public void setShort(long index, int additionalOffset, short value) {
        this.getBuffer(index).putShort(this.offset(index) + additionalOffset, value);
    }

    @Override
    public void set3ByteInt(long index, int additionalOffset, int value) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        b.putShort(o, (short)value);
        b.put(o + 2, (byte)(value >>> 16));
    }

    @Override
    public void setInt(long index, int additionalOffset, int value) {
        this.getBuffer(index).putInt(this.offset(index) + additionalOffset, value);
    }

    @Override
    public void set5ByteLong(long index, int additionalOffset, long value) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        b.putInt(o, (int)value);
        b.put(o + 4, (byte)(value >>> 32));
    }

    @Override
    public void set6ByteLong(long index, int additionalOffset, long value) {
        ByteBuffer b = this.getBuffer(index);
        int o = this.offset(index) + additionalOffset;
        b.putInt(o, (int)value);
        b.putShort(o + 4, (short)(value >>> 32));
    }

    @Override
    public void setLong(long index, int additionalOffset, long value) {
        this.getBuffer(index).putLong(this.offset(index) + additionalOffset, value);
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        ByteBuffer fromBuffer = this.getBuffer(fromIndex);
        ByteBuffer toBuffer = this.getBuffer(toIndex);
        int fromOffset = this.offset(fromIndex);
        int toOffset = this.offset(toIndex);
        if (this.elementSize == 1) {
            byte tmp = fromBuffer.get(fromOffset);
            fromBuffer.put(fromOffset, toBuffer.get(toOffset));
            toBuffer.put(toOffset, tmp);
        } else if (this.elementSize == 2) {
            short tmp = fromBuffer.getShort(fromOffset);
            fromBuffer.putShort(fromOffset, toBuffer.getShort(toOffset));
            toBuffer.putShort(toOffset, tmp);
        } else if (this.elementSize == 4) {
            int tmp = fromBuffer.getInt(fromOffset);
            fromBuffer.putInt(fromOffset, toBuffer.getInt(toOffset));
            toBuffer.putInt(toOffset, tmp);
        } else if (this.elementSize == 8) {
            long tmp = fromBuffer.getLong(fromOffset);
            fromBuffer.putLong(fromOffset, toBuffer.getLong(toOffset));
            toBuffer.putLong(toOffset, tmp);
        } else {
            byte[] tmp = new byte[this.elementSize];
            fromBuffer.get(fromOffset, tmp);
            fromBuffer.put(fromOffset, toBuffer, toOffset, this.elementSize);
            toBuffer.put(toOffset, tmp);
        }
    }

    private static long signExtension(long value, long signMask) {
        return (value & signMask) == 0L ? value : value | signMask;
    }

    private static int signExtension(int value, int signMask) {
        return (value & signMask) == 0 ? value : value | signMask;
    }
}

