/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api.input;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.internal.id.IdSequence;

public interface InputEntityVisitor
extends Closeable {
    public static final InputEntityVisitor NULL = new InputEntityVisitor(){};

    default public boolean propertyId(long nextProp) {
        return true;
    }

    default public boolean properties(ByteBuffer properties, boolean offloaded) {
        return true;
    }

    default public boolean property(String key, Object value, boolean identifier) {
        return true;
    }

    default public boolean property(int propertyKeyId, Object value, boolean identifier) {
        return true;
    }

    default public boolean removedProperties(String[] keys) {
        return true;
    }

    default public boolean removedProperties(int[] keys) {
        return true;
    }

    default public boolean id(long id) {
        return true;
    }

    default public boolean id(Object id, Group group) {
        return true;
    }

    default public boolean id(Object id, Group group, IdSequence idSequence) {
        return true;
    }

    default public boolean labels(String[] labels) {
        return true;
    }

    default public boolean labels(int[] labels) {
        return true;
    }

    default public boolean removedLabels(String[] labels) {
        return true;
    }

    default public boolean removedLabels(int[] labels) {
        return true;
    }

    default public boolean labelField(long labelField) {
        return true;
    }

    default public boolean startId(long id) {
        return true;
    }

    default public boolean startId(Object id, Group group) {
        return true;
    }

    default public boolean endId(long id) {
        return true;
    }

    default public boolean endId(Object id, Group group) {
        return true;
    }

    default public boolean type(int type) {
        return true;
    }

    default public boolean type(String type) {
        return true;
    }

    default public boolean applicationMode(ApplicationMode mode) {
        return true;
    }

    default public void endOfEntity() throws IOException {
    }

    default public void reset() {
    }

    @Override
    default public void close() throws IOException {
    }

    default public void flush() throws IOException {
    }

    public static class Delegate
    implements InputEntityVisitor {
        private final InputEntityVisitor actual;

        public Delegate(InputEntityVisitor actual) {
            this.actual = actual;
        }

        @Override
        public boolean propertyId(long nextProp) {
            return this.actual.propertyId(nextProp);
        }

        @Override
        public boolean properties(ByteBuffer properties, boolean offloaded) {
            return this.actual.properties(properties, offloaded);
        }

        @Override
        public boolean property(String key, Object value, boolean identifier) {
            return this.actual.property(key, value, identifier);
        }

        @Override
        public boolean property(int propertyKeyId, Object value, boolean identifier) {
            return this.actual.property(propertyKeyId, value, identifier);
        }

        @Override
        public boolean removedProperties(String[] keys) {
            return this.actual.removedProperties(keys);
        }

        @Override
        public boolean id(long id) {
            return this.actual.id(id);
        }

        @Override
        public boolean id(Object id, Group group) {
            return this.actual.id(id, group);
        }

        @Override
        public boolean id(Object id, Group group, IdSequence idSequence) {
            return this.actual.id(id, group, idSequence);
        }

        @Override
        public boolean labels(String[] labels) {
            return this.actual.labels(labels);
        }

        @Override
        public boolean labels(int[] labels) {
            return this.actual.labels(labels);
        }

        @Override
        public boolean removedLabels(String[] labels) {
            return this.actual.removedLabels(labels);
        }

        @Override
        public boolean removedLabels(int[] labels) {
            return this.actual.removedLabels(labels);
        }

        @Override
        public boolean labelField(long labelField) {
            return this.actual.labelField(labelField);
        }

        @Override
        public boolean startId(long id) {
            return this.actual.startId(id);
        }

        @Override
        public boolean startId(Object id, Group group) {
            return this.actual.startId(id, group);
        }

        @Override
        public boolean endId(long id) {
            return this.actual.endId(id);
        }

        @Override
        public boolean endId(Object id, Group group) {
            return this.actual.endId(id, group);
        }

        @Override
        public boolean type(int type) {
            return this.actual.type(type);
        }

        @Override
        public boolean type(String type) {
            return this.actual.type(type);
        }

        @Override
        public boolean applicationMode(ApplicationMode mode) {
            return this.actual.applicationMode(mode);
        }

        @Override
        public void endOfEntity() throws IOException {
            this.actual.endOfEntity();
        }

        @Override
        public void reset() {
            this.actual.reset();
        }

        @Override
        public void close() throws IOException {
            this.actual.close();
        }

        @Override
        public boolean removedProperties(int[] keys) {
            return this.actual.removedProperties(keys);
        }

        @Override
        public void flush() throws IOException {
            this.actual.flush();
        }
    }

    public static class Adapter
    implements InputEntityVisitor {
        @Override
        public boolean property(String key, Object value, boolean identifier) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean properties(ByteBuffer properties, boolean offloaded) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean property(int propertyKeyId, Object value, boolean identifier) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean propertyId(long nextProp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removedProperties(String[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removedProperties(int[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean id(long id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean id(Object id, Group group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean id(Object id, Group group, IdSequence idSequence) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean labels(String[] labels) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean labels(int[] labels) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removedLabels(String[] labels) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removedLabels(int[] labels) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean startId(long id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean startId(Object id, Group group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean endId(long id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean endId(Object id, Group group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean type(int type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean type(String type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean labelField(long labelField) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean applicationMode(ApplicationMode mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void endOfEntity() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

