/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api.input;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaTokens;
import org.neo4j.token.TokenHolders;

public interface Input
extends AutoCloseable {
    public static final String CONFIG_IDENTIFIER = "identifier";

    public InputIterable nodes(Collector var1);

    public InputIterable relationships(Collector var1);

    public IdType idType();

    public ReadableGroups groups();

    public Estimates validateAndEstimate(PropertySizeCalculator var1) throws IOException;

    default public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        throw new UnsupportedOperationException();
    }

    default public List<SchemaCommand> schemaCommands() {
        return List.of();
    }

    default public SchemaTokens schemaTokens() {
        return SchemaTokens.collect(this.schemaCommands());
    }

    public boolean containsVectorData();

    @Override
    default public void close() {
    }

    public static Input input(final InputIterable nodes, final InputIterable relationships, final IdType idType, final Estimates estimates, final ReadableGroups groups, final boolean containsVectorData) {
        return new Input(){

            @Override
            public InputIterable relationships(Collector badCollector) {
                return relationships;
            }

            @Override
            public InputIterable nodes(Collector badCollector) {
                return nodes;
            }

            @Override
            public IdType idType() {
                return idType;
            }

            @Override
            public ReadableGroups groups() {
                return groups;
            }

            @Override
            public Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) {
                return estimates;
            }

            @Override
            public boolean containsVectorData() {
                return containsVectorData;
            }
        };
    }

    public static Estimates knownEstimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels) {
        return Input.knownEstimates(numberOfNodes, numberOfRelationships, numberOfNodeProperties, numberOfRelationshipProperties, sizeOfNodeProperties, sizeOfRelationshipProperties, numberOfNodeLabels, false, false);
    }

    public static Estimates knownEstimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels, boolean containsNodeUpdates, boolean containsRelationshipUpdates) {
        return new Estimates(numberOfNodes, numberOfRelationships, numberOfNodeProperties, numberOfRelationshipProperties, sizeOfNodeProperties, sizeOfRelationshipProperties, numberOfNodeLabels, containsNodeUpdates, containsRelationshipUpdates);
    }

    public static Input estimatesCachingInput(Input actual) {
        return new Delegate(actual){
            private Estimates estimates;

            @Override
            public Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
                if (this.estimates == null) {
                    this.estimates = super.validateAndEstimate(valueSizeCalculator);
                }
                return this.estimates;
            }
        };
    }

    public record Estimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels, boolean containsNodeUpdates, boolean containsRelationshipUpdates) {
    }

    public static class Delegate
    implements Input {
        protected final Input delegate;

        public Delegate(Input delegate) {
            this.delegate = delegate;
        }

        @Override
        public InputIterable relationships(Collector badCollector) {
            return this.delegate.relationships(badCollector);
        }

        @Override
        public InputIterable nodes(Collector badCollector) {
            return this.delegate.nodes(badCollector);
        }

        @Override
        public IdType idType() {
            return this.delegate.idType();
        }

        @Override
        public ReadableGroups groups() {
            return this.delegate.groups();
        }

        @Override
        public Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
            return this.delegate.validateAndEstimate(valueSizeCalculator);
        }

        @Override
        public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
            return this.delegate.referencedNodeSchema(tokenHolders);
        }

        @Override
        public List<SchemaCommand> schemaCommands() {
            return this.delegate.schemaCommands();
        }

        @Override
        public SchemaTokens schemaTokens() {
            return this.delegate.schemaTokens();
        }

        @Override
        public boolean containsVectorData() {
            return this.delegate.containsVectorData();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

