/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api;

import java.nio.file.Path;
import org.neo4j.batchimport.api.IndexConfig;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.ToolingMemoryCalculations;
import org.neo4j.io.pagecache.ExternallyManagedPageCache;
import org.neo4j.util.FeatureToggles;

public interface Configuration {
    public static final int DEFAULT_BATCH_SIZE = FeatureToggles.getInteger(Configuration.class, (String)"DEFAULT_BATCH_SIZE", (int)10000);
    public static final int DEFAULT_MAX_MEMORY_PERCENT = 90;
    public static final Configuration DEFAULT = new Configuration(){};

    default public int batchSize() {
        return DEFAULT_BATCH_SIZE;
    }

    default public int movingAverageSize() {
        return 100;
    }

    default public int maxNumberOfWorkerThreads() {
        return Configuration.allAvailableProcessors();
    }

    default public int maxQueueSize() {
        return this.maxNumberOfWorkerThreads();
    }

    public static int allAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    default public long maxOffHeapMemory() {
        return new ToolingMemoryCalculations(ToolingMemoryCalculations.NO_MONITOR).calculateMaxAvailableOffHeapMemoryFromPercent(90);
    }

    default public boolean sequentialBackgroundFlushing() {
        return true;
    }

    default public boolean parallelRecordWrites() {
        return true;
    }

    default public boolean parallelRecordReads() {
        return true;
    }

    default public boolean highIO() {
        return true;
    }

    default public boolean strictNodeCheck() {
        return false;
    }

    default public IndexConfig indexConfig() {
        return IndexConfig.create();
    }

    default public boolean defragmentInternalStores() {
        return true;
    }

    default public boolean updateAllMatchingRelationships() {
        return false;
    }

    default public int forcedNumberOfNodeIdRanges() {
        return -1;
    }

    default public ExternallyManagedPageCache providedPageCache() {
        return null;
    }

    default public Path tempDirectory(Path databaseDirectory) {
        return databaseDirectory.resolve("temp");
    }

    public static Configuration defaultConfiguration() {
        return new Overridden(DEFAULT){

            @Override
            public boolean highIO() {
                return true;
            }
        };
    }

    public static Configuration withBatchSize(Configuration config, final int batchSize) {
        return new Overridden(config){

            @Override
            public int batchSize() {
                return batchSize;
            }
        };
    }

    public static class Overridden
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public Overridden(Configuration defaults) {
            this(defaults, Config.defaults());
        }

        public Overridden(Configuration defaults, Config config) {
            this.defaults = defaults;
            this.config = config;
        }

        public Overridden(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }

        @Override
        public boolean sequentialBackgroundFlushing() {
            return this.defaults.sequentialBackgroundFlushing();
        }

        @Override
        public int batchSize() {
            return this.defaults.batchSize();
        }

        @Override
        public int maxNumberOfWorkerThreads() {
            Integer upgradeProcessors = (Integer)this.config.get(GraphDatabaseInternalSettings.upgrade_processors);
            if (upgradeProcessors == 0) {
                return this.defaults.maxNumberOfWorkerThreads();
            }
            return upgradeProcessors;
        }

        @Override
        public boolean parallelRecordWrites() {
            return this.defaults.parallelRecordWrites();
        }

        @Override
        public boolean parallelRecordReads() {
            return this.defaults.parallelRecordReads();
        }

        @Override
        public boolean highIO() {
            return this.defaults.highIO();
        }

        @Override
        public long maxOffHeapMemory() {
            return this.defaults.maxOffHeapMemory();
        }

        @Override
        public boolean defragmentInternalStores() {
            return this.defaults.defragmentInternalStores();
        }

        @Override
        public int forcedNumberOfNodeIdRanges() {
            return this.defaults.forcedNumberOfNodeIdRanges();
        }

        @Override
        public boolean updateAllMatchingRelationships() {
            return this.defaults.updateAllMatchingRelationships();
        }

        @Override
        public ExternallyManagedPageCache providedPageCache() {
            return this.defaults.providedPageCache();
        }

        @Override
        public IndexConfig indexConfig() {
            return this.defaults.indexConfig();
        }
    }
}

