/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Objects;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public final class QueryExecutionType {
    private final Execution execution;
    private final QueryType type;

    public static QueryExecutionType query(QueryType type) {
        return Objects.requireNonNull(type, (String)"QueryType").query;
    }

    public static QueryExecutionType profiled(QueryType type) {
        return Objects.requireNonNull(type, (String)"QueryType").profiled;
    }

    public static QueryExecutionType explained(QueryType type) {
        return Objects.requireNonNull(type, (String)"QueryType").explained;
    }

    public QueryType queryType() {
        return this.type;
    }

    public boolean isProfiled() {
        return this.execution == Execution.PROFILE;
    }

    public boolean requestedExecutionPlanDescription() {
        return this.execution != Execution.QUERY;
    }

    public boolean isExplained() {
        return this.execution == Execution.EXPLAIN;
    }

    public boolean canContainResults() {
        return (this.type == QueryType.READ_ONLY || this.type == QueryType.READ_WRITE) && this.execution != Execution.EXPLAIN;
    }

    public boolean canUpdateData() {
        return (this.type == QueryType.READ_WRITE || this.type == QueryType.WRITE) && this.execution != Execution.EXPLAIN;
    }

    public boolean canUpdateSchema() {
        return this.type == QueryType.SCHEMA_WRITE && this.execution != Execution.EXPLAIN;
    }

    private QueryExecutionType(Execution execution, QueryType type) {
        this.execution = execution;
        this.type = type;
    }

    public String toString() {
        return this.execution.toString(this.type);
    }

    private static enum Execution {
        QUERY{

            @Override
            String toString(QueryType type) {
                return type.name();
            }
        }
        ,
        PROFILE,
        EXPLAIN;


        String toString(QueryType type) {
            return this.name() + ":" + type.name();
        }
    }

    public static enum QueryType {
        READ_ONLY,
        READ_WRITE,
        WRITE,
        SCHEMA_WRITE,
        DBMS;

        private final QueryExecutionType query = new QueryExecutionType(Execution.QUERY, this);
        private final QueryExecutionType profiled = new QueryExecutionType(Execution.PROFILE, this);
        private final QueryExecutionType explained = new QueryExecutionType(Execution.EXPLAIN, this);
    }
}

