/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import org.neo4j.annotations.api.PublicApi;

@PublicApi
public class IndexPopulationProgress {
    public static final IndexPopulationProgress NONE = new IndexPopulationProgress(0L, 0L);
    public static final IndexPopulationProgress DONE = new IndexPopulationProgress(1L, 1L);
    private final long completedCount;
    private final long totalCount;

    public IndexPopulationProgress(long completed, long total) {
        if (completed < 0L || completed > total) {
            throw new IllegalArgumentException("Invalid progress specified: " + completed + "/" + total);
        }
        this.completedCount = completed;
        this.totalCount = total;
    }

    public float getCompletedPercentage() {
        return this.totalCount > 0L ? (float)(this.completedCount * 100L) / (float)this.totalCount : 0.0f;
    }

    public String toString() {
        return String.format("%1.1f%%", Float.valueOf(this.getCompletedPercentage()));
    }
}

