/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.Locker;
import org.neo4j.kernel.impl.transaction.TransactionImpl;

class Neo4j19Locker
extends Locker {
    private final TransactionManager txManager;

    public Neo4j19Locker(GraphDatabaseService graphDatabaseService) {
        if (!(graphDatabaseService instanceof GraphDatabaseAPI)) {
            throw new RuntimeException("Error accessing transaction management, not a GraphDatabaseAPI " + graphDatabaseService);
        }
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)graphDatabaseService;
        this.txManager = (TransactionManager)graphDatabaseAPI.getDependencyResolver().resolveDependency(TransactionManager.class);
    }

    @Override
    public void acquireLock(LockType lockType, PropertyContainer element) {
        TransactionImpl tx = this.getCurrentTransaction();
        if (tx == null) {
            return;
        }
        TransactionState state = tx.getState();
        switch (lockType) {
            case READ: {
                state.acquireReadLock((Object)element);
                break;
            }
            case WRITE: {
                state.acquireWriteLock((Object)element);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown lock type " + lockType);
            }
        }
    }

    private TransactionImpl getCurrentTransaction() {
        try {
            return (TransactionImpl)this.txManager.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException("Error accessing current transaction", e);
        }
    }
}

