/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.lang.reflect.Method;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.Locker;
import org.neo4j.kernel.impl.transaction.TransactionImpl;

class Neo4j18Locker
extends Locker {
    private final Object lockManager;
    private final Object lockReleaser;
    private final TransactionManager txManager;

    public Neo4j18Locker(GraphDatabaseService graphDatabaseService) {
        if (!(graphDatabaseService instanceof AbstractGraphDatabase)) {
            throw new RuntimeException("Error accessing transaction management, not a AbstractGraphDatabase " + graphDatabaseService);
        }
        AbstractGraphDatabase graphDatabase = (AbstractGraphDatabase)graphDatabaseService;
        this.lockManager = graphDatabase.getLockManager();
        this.txManager = graphDatabase.getTxManager();
        this.lockReleaser = this.invoke(graphDatabase, "getLockReleaser", new Pair[0]);
    }

    private Object invoke(Object target, String methodName, Pair<Class, ?> ... params) {
        try {
            Class[] types = new Class[params.length];
            Object[] values = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = (Class)params[i].first();
                values[i] = params[i].other();
            }
            Method method = target.getClass().getMethod(methodName, types);
            return method.invoke(target, values);
        }
        catch (Exception e) {
            System.out.println(target);
            System.out.println(target.getClass());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void acquireLock(LockType lockType, PropertyContainer element) {
        TransactionImpl tx = this.getCurrentTransaction();
        switch (lockType) {
            case READ: {
                this.invoke(this.lockManager, "getReadLock", Pair.of(Object.class, (Object)element), Pair.of(Transaction.class, (Object)tx));
                this.invoke(this.lockReleaser, "addLockToTransaction", Pair.of(Object.class, (Object)element), Pair.of(LockType.class, (Object)LockType.READ), Pair.of(Transaction.class, (Object)tx));
                break;
            }
            case WRITE: {
                this.invoke(this.lockManager, "getWriteLock", Pair.of(Object.class, (Object)element), Pair.of(Transaction.class, (Object)tx));
                this.invoke(this.lockReleaser, "addLockToTransaction", Pair.of(Object.class, (Object)element), Pair.of(LockType.class, (Object)LockType.WRITE), Pair.of(Transaction.class, (Object)tx));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown lock type " + lockType);
            }
        }
    }

    private TransactionImpl getCurrentTransaction() {
        try {
            return (TransactionImpl)this.txManager.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException("Error accessing current transaction", e);
        }
    }
}

