/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.indexprovider;

import org.neo4j.collections.indexprovider.TimelineIndexProvider;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class TimelineIndexKernelExtensionFactory
extends KernelExtensionFactory<Depencies> {
    public TimelineIndexKernelExtensionFactory() {
        super("graph-collections-timeline");
    }

    public Lifecycle newKernelExtension(Depencies depencies) throws Throwable {
        return new TimelineIndexKerneExtension(depencies.getGraphDatabaseService(), depencies.getIndexProviders());
    }

    public static class TimelineIndexKerneExtension
    implements Lifecycle {
        private final GraphDatabaseService graphDatabaseService;
        private final IndexProviders indexProviders;

        public TimelineIndexKerneExtension(GraphDatabaseService graphDatabaseService, IndexProviders indexProviders) {
            this.graphDatabaseService = graphDatabaseService;
            this.indexProviders = indexProviders;
        }

        public void init() throws Throwable {
        }

        public void start() throws Throwable {
            TimelineIndexProvider.TimelineIndexImplementation indexImplementation = new TimelineIndexProvider.TimelineIndexImplementation(this.graphDatabaseService);
            this.indexProviders.registerIndexProvider("graph-collections-timeline", (IndexImplementation)indexImplementation);
        }

        public void stop() throws Throwable {
            this.indexProviders.unregisterIndexProvider("graph-collections-timeline");
        }

        public void shutdown() throws Throwable {
        }
    }

    public static interface Depencies {
        public IndexProviders getIndexProviders();

        public GraphDatabaseService getGraphDatabaseService();
    }
}

