/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.indexedrelationship;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collections.GraphCollection;
import org.neo4j.collections.indexedrelationship.IndexedRelationship;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.kernel.Traversal;

public class IndexedRelationshipExpander
implements RelationshipExpander {
    private final Direction direction;
    private final RelationshipType relType;
    private final GraphDatabaseService graphDb;

    public IndexedRelationshipExpander(GraphDatabaseService graphDb, Direction direction, RelationshipType relType) {
        this.direction = direction;
        this.relType = relType;
        this.graphDb = graphDb;
    }

    public Iterable<Relationship> expand(Node node) {
        return new RelationshipIterable(node);
    }

    public RelationshipExpander reversed() {
        return new IndexedRelationshipExpander(this.graphDb, this.direction.reverse(), this.relType);
    }

    class RelationshipIterator
    implements Iterator<Relationship> {
        final Iterator<Relationship> directRelationshipIterator;
        final Iterator<Relationship> indexedRelationshipIterator;
        final Iterator<Path> indexedRelationshipDestinationIterator;
        boolean inIndexedRelationshipIterator = false;

        RelationshipIterator(Node node, final RelationshipType relType, final Direction direction) {
            this.directRelationshipIterator = node.hasRelationship(relType, direction) ? node.getRelationships(relType, direction).iterator() : null;
            IndexedRelationship indexedRelationship = new IndexedRelationship(node, relType, direction);
            this.indexedRelationshipIterator = !indexedRelationship.exists() ? null : indexedRelationship.iterator();
            this.indexedRelationshipDestinationIterator = Traversal.description().depthFirst().evaluator(new Evaluator(){

                public Evaluation evaluate(Path path) {
                    if (path.length() == 0) {
                        return Evaluation.EXCLUDE_AND_CONTINUE;
                    }
                    Relationship relationship = path.lastRelationship();
                    if (path.length() == 1) {
                        if (relationship.getType().equals((Object)GraphCollection.RelationshipTypes.VALUE)) {
                            String relationshipType = (String)relationship.getProperty("relationship_type", null);
                            String relationshipDirection = (String)relationship.getProperty("relationship_direction", null);
                            if (relType.name().equals(relationshipType) && direction.reverse().name().equals(relationshipDirection)) {
                                return Evaluation.EXCLUDE_AND_CONTINUE;
                            }
                        }
                        return Evaluation.EXCLUDE_AND_PRUNE;
                    }
                    if (relationship.getType().equals((Object)IndexedRelationship.RelationshipTypes.NODE_COLLECTION)) {
                        return Evaluation.INCLUDE_AND_PRUNE;
                    }
                    return Evaluation.EXCLUDE_AND_CONTINUE;
                }
            }).traverse(node).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.directRelationshipIterator != null && this.directRelationshipIterator.hasNext()) {
                return true;
            }
            if (this.indexedRelationshipIterator != null && this.indexedRelationshipIterator.hasNext()) {
                return true;
            }
            return this.indexedRelationshipDestinationIterator != null && this.indexedRelationshipDestinationIterator.hasNext();
        }

        @Override
        public Relationship next() {
            if (this.directRelationshipIterator != null && this.directRelationshipIterator.hasNext()) {
                return this.directRelationshipIterator.next();
            }
            if (this.indexedRelationshipIterator != null && this.indexedRelationshipIterator.hasNext()) {
                return this.indexedRelationshipIterator.next();
            }
            if (this.indexedRelationshipDestinationIterator != null && this.indexedRelationshipDestinationIterator.hasNext()) {
                Path path = this.indexedRelationshipDestinationIterator.next();
                String direction = (String)path.lastRelationship().getProperty("relationship_direction");
                try {
                    IndexedRelationship indexedRelationship = new IndexedRelationship(path.endNode(), IndexedRelationshipExpander.this.relType, Direction.valueOf((String)direction));
                    return indexedRelationship.getRelationship((Relationship)path.relationships().iterator().next());
                }
                catch (Exception e) {
                    throw new RuntimeException("Comparator class cannot be instantiated");
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.directRelationshipIterator != null && !this.inIndexedRelationshipIterator) {
                this.directRelationshipIterator.remove();
            } else if (this.indexedRelationshipIterator != null) {
                this.indexedRelationshipIterator.remove();
            }
        }
    }

    class RelationshipIterable
    implements Iterable<Relationship> {
        final Node node;

        RelationshipIterable(Node node) {
            this.node = node;
        }

        @Override
        public Iterator<Relationship> iterator() {
            return new RelationshipIterator(this.node, IndexedRelationshipExpander.this.relType, IndexedRelationshipExpander.this.direction);
        }
    }
}

