/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.rtree;

import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.EnvelopeDecoder;
import org.neo4j.graphdb.PropertyContainer;

public class EnvelopeDecoderFromDoubleArray
implements EnvelopeDecoder {
    private String propertyName;

    public EnvelopeDecoderFromDoubleArray(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Envelope decodeEnvelope(PropertyContainer container) {
        Object propValue = container.getProperty(this.propertyName);
        if (propValue instanceof Double[]) {
            Double[] bbox = (Double[])propValue;
            return new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        }
        if (propValue instanceof double[]) {
            double[] bbox = (double[])propValue;
            return new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        }
        return new Envelope();
    }
}

