/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collections.graphdb.BijectiveConnectionMode;
import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.Connection;
import org.neo4j.collections.graphdb.Connector;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.Property;
import org.neo4j.collections.graphdb.PropertyType;
import org.neo4j.collections.graphdb.RightRestrictedConnectionMode;
import org.neo4j.collections.graphdb.SortableBinaryEdge;
import org.neo4j.collections.graphdb.SortableBinaryEdgeType;
import org.neo4j.collections.graphdb.Traversal;
import org.neo4j.collections.graphdb.TraversalDescription;
import org.neo4j.collections.graphdb.TraversalPath;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.EdgeImpl;
import org.neo4j.collections.graphdb.impl.NullaryEdgeImpl;
import org.neo4j.collections.graphdb.impl.RelationshipIterable;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class VertexImpl
implements Vertex {
    public static final String EDGEROLE_SEPARATOR = "/#/";
    public static final String TYPE_IDS = "org.neo4j.collections.graphdb.type_ids";
    protected final long id;
    protected final DatabaseService db;

    public VertexImpl(DatabaseService db, Long id) {
        this.id = id;
        this.db = db;
    }

    @Override
    public Vertex addEdge(Vertex vertex, RelationshipType type) {
        this.createEdgeTo(vertex, type);
        return this;
    }

    @Override
    public Vertex addEdge(Vertex vertex, SortableBinaryEdgeType<?> type) {
        this.createEdgeTo(vertex, type);
        return this;
    }

    @Override
    public Vertex addType(VertexType vertexType) {
        Long[] nodeIds = (Long[])this.getNode().getProperty(TYPE_IDS);
        boolean exists = false;
        for (Long id : nodeIds) {
            if (id.longValue() != vertexType.getNode().getId()) continue;
            exists = true;
        }
        if (!exists) {
            Long[] ids = new Long[nodeIds.length + 1];
            for (int i = 0; i < nodeIds.length; ++i) {
                ids[i] = nodeIds[i];
            }
            ids[nodeIds.length] = vertexType.getNode().getId();
        }
        return this;
    }

    @Override
    public BinaryEdge createEdgeTo(Vertex vertex, RelationshipType type) {
        return this.db.getBinaryEdgeType(type).createEdge(this, vertex);
    }

    @Override
    public <T> SortableBinaryEdge<T> createEdgeTo(Vertex vertex, SortableBinaryEdgeType<T> type) {
        return type.createEdge(this, vertex);
    }

    @Override
    public Iterable<BinaryEdge> getBinaryEdges() {
        return new RelationshipIterable(this.getNode().getRelationships());
    }

    @Override
    public Iterable<BinaryEdge> getBinaryEdges(Direction dir) {
        return new RelationshipIterable(this.getNode().getRelationships(dir));
    }

    @Override
    public Iterable<BinaryEdge> getBinaryEdges(Direction dir, RelationshipType ... relTypes) {
        return new RelationshipIterable(this.getNode().getRelationships(dir, relTypes));
    }

    @Override
    public Iterable<BinaryEdge> getBinaryEdges(RelationshipType ... relTypes) {
        return new RelationshipIterable(this.getNode().getRelationships(relTypes));
    }

    @Override
    public Iterable<BinaryEdge> getBinaryEdges(RelationshipType relType, Direction dir) {
        return this.db.getBinaryEdgeType(relType).getEdges((Vertex)this, dir);
    }

    @Override
    public DatabaseService getDb() {
        return this.db;
    }

    @Override
    public Iterable<Edge> getEdges(EdgeType ... edgeTypes) {
        return new EdgeTypeIterable(this, edgeTypes);
    }

    @Override
    public Iterable<Edge> getEdges(EdgeType type, ConnectorType<?> ... connectors) {
        return type.getEdges(this, connectors);
    }

    @Override
    public Node getNode() {
        return this.db.getNodeById(this.id);
    }

    @Override
    public <T> Property<T> getProperty(PropertyType<T> pt) {
        return pt.getProperty(this);
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getNode();
    }

    @Override
    public Iterable<PropertyType<?>> getPropertyTypes() {
        return new PropertyTypeIterable(this.getNode());
    }

    @Override
    public <T> T getPropertyValue(PropertyType<T> pt) {
        return pt.getPropertyValue(this);
    }

    @Override
    public BinaryEdge getSingleBinaryEdge(RelationshipType type, Direction dir) {
        return this.db.getBinaryEdgeType(type).getSingleBinaryEdge(this, dir);
    }

    protected VertexType getSpecialVertexType() {
        return null;
    }

    @Override
    public Iterable<VertexType> getTypes() {
        return new VertexTypeIterable();
    }

    @Override
    public boolean hasBinaryEdge() {
        return this.getNode().hasRelationship();
    }

    @Override
    public boolean hasBinaryEdge(Direction dir) {
        return this.getNode().hasRelationship(dir);
    }

    @Override
    public boolean hasBinaryEdge(Direction dir, RelationshipType ... relTypes) {
        return this.getNode().hasRelationship(dir, relTypes);
    }

    @Override
    public boolean hasBinaryEdge(RelationshipType ... relType) {
        return this.getNode().hasRelationship(relType);
    }

    @Override
    public boolean hasBinaryEdge(RelationshipType relType, Direction dir) {
        return this.db.getBinaryEdgeType(relType).hasEdge((Vertex)this, dir);
    }

    @Override
    public boolean hasEdge(EdgeType edgeType, ConnectorType<?> ... connectors) {
        return edgeType.hasEdge(this, connectors);
    }

    @Override
    public <T> boolean hasProperty(PropertyType<T> pt) {
        return pt.hasProperty(this);
    }

    @Override
    public Iterator<Traversal> iterator() {
        return new TraversalIterator();
    }

    @Override
    public Vertex removeProperty(PropertyType<?> pt) {
        pt.removeProperty(this);
        return this;
    }

    @Override
    public Vertex removeType(VertexType vertexType) {
        Long[] nodeIds = (Long[])this.getNode().getProperty(TYPE_IDS);
        boolean exists = false;
        for (Long id : nodeIds) {
            if (id.longValue() != vertexType.getNode().getId()) continue;
            exists = true;
        }
        if (!exists) {
            Long[] ids = new Long[nodeIds.length - 1];
            boolean skipped = false;
            for (int i = 0; i < nodeIds.length; ++i) {
                if (skipped) {
                    ids[i - 1] = nodeIds[i];
                    continue;
                }
                if (ids[i] == nodeIds[i]) {
                    skipped = true;
                    continue;
                }
                ids[i] = nodeIds[i];
            }
            ids[nodeIds.length] = vertexType.getNode().getId();
        }
        return this;
    }

    @Override
    public <T> Vertex setProperty(PropertyType<T> pt, T value) {
        pt.setProperty(this, value);
        return this;
    }

    @Override
    public TraversalPath getPath() {
        return new TraversalPath(){

            @Override
            public Iterator<Connection<?>> iterator() {
                return new Iterator<Connection<?>>(){
                    boolean hasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public Connection<?> next() {
                        if (this.hasNext) {
                            this.hasNext = false;
                            return VertexImpl.this.getSelfConnection();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            @Override
            public Connection<?> getFirstElement() {
                return VertexImpl.this.getSelfConnection();
            }

            @Override
            public Connection<?> getLastElement() {
                return VertexImpl.this.getSelfConnection();
            }

            @Override
            public int length() {
                return 0;
            }
        };
    }

    @Override
    public Connection<BijectiveConnectionMode> getSelfConnection() {
        NullaryEdgeImpl edge = new NullaryEdgeImpl(this.db, this.getNode().getId());
        return new Connection<BijectiveConnectionMode>(Connector.getInstance(edge.getType().getConnectorType("NullaryConnector"), edge), this);
    }

    @Override
    public Traversal traverse(TraversalDescription descr) {
        return descr.traverse(this);
    }

    @Override
    public Iterable<TraversalPath> getContainedPaths() {
        ArrayList<TraversalPath> paths = new ArrayList<TraversalPath>();
        return paths;
    }

    @Override
    public Edge getEdge(EdgeType edgeType, ConnectorType<RightRestrictedConnectionMode> connectorType) {
        Relationship rel = this.getNode().getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)(edgeType.getName() + EDGEROLE_SEPARATOR + connectorType.getName())), Direction.INCOMING);
        if (rel == null) {
            return null;
        }
        return new EdgeImpl(this.db, rel.getStartNode().getId());
    }

    private class VertexTypeIterator
    implements Iterator<VertexType> {
        private final Iterator<Node> nodes;
        boolean foundSpecial = false;
        VertexType special = VertexImpl.this.getSpecialVertexType();

        public VertexTypeIterator() {
            Long[] nodeIds;
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Long id : nodeIds = (Long[])VertexImpl.this.getNode().getProperty(VertexImpl.TYPE_IDS)) {
                nodes.add(VertexImpl.this.db.getNodeById(id));
            }
            this.nodes = nodes.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nodes.hasNext()) {
                return true;
            }
            if (this.foundSpecial) {
                return false;
            }
            return this.special != null;
        }

        @Override
        public VertexType next() {
            if (this.hasNext()) {
                if (this.nodes.hasNext()) {
                    VertexType vertexType = (VertexType)VertexImpl.this.db.getVertex(this.nodes.next());
                    if (this.special.getName().equals(vertexType.getName())) {
                        this.foundSpecial = true;
                    }
                    return vertexType;
                }
                return this.special;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    private class VertexTypeIterable
    implements Iterable<VertexType> {
        private VertexTypeIterable() {
        }

        @Override
        public Iterator<VertexType> iterator() {
            return new VertexTypeIterator();
        }
    }

    class PropertyTypeIterator
    implements Iterator<PropertyType<?>> {
        final Iterator<String> keys;

        PropertyTypeIterator(Node n) {
            this.keys = n.getPropertyKeys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public PropertyType<?> next() {
            return PropertyType.getPropertyTypeByName(VertexImpl.this.db, this.keys.next());
        }

        @Override
        public void remove() {
        }
    }

    class PropertyTypeIterable
    implements Iterable<PropertyType<?>> {
        final Node node;

        public PropertyTypeIterable(Node node) {
            this.node = node;
        }

        @Override
        public Iterator<PropertyType<?>> iterator() {
            return new PropertyTypeIterator(this.node);
        }
    }

    class TraversalIterator
    implements Iterator<Traversal> {
        TraversalIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Traversal next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    static class EdgeTypeIterator
    implements Iterator<Edge> {
        Iterator<EdgeType> edgeTypes;
        ConnectorTypeIterator currentConnectorTypeIterator = null;
        Boolean hasNext = null;
        private final Vertex vertex;

        EdgeTypeIterator(Iterator<EdgeType> edgeTypes, Vertex vertex) {
            this.edgeTypes = edgeTypes;
            this.vertex = vertex;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                if (this.currentConnectorTypeIterator == null) {
                    if (this.edgeTypes.hasNext()) {
                        EdgeType edgeType = this.edgeTypes.next();
                        this.currentConnectorTypeIterator = new ConnectorTypeIterator(edgeType, edgeType.getConnectorTypes().iterator(), this.vertex);
                        return this.hasNext();
                    }
                    this.hasNext = false;
                    return false;
                }
                if (this.currentConnectorTypeIterator.hasNext()) {
                    this.hasNext = true;
                    return true;
                }
                this.currentConnectorTypeIterator = null;
                return this.hasNext();
            }
            return this.hasNext;
        }

        @Override
        public Edge next() {
            if (this.hasNext()) {
                this.hasNext = null;
                return this.currentConnectorTypeIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    static class EdgeTypeIterable
    implements Iterable<Edge> {
        EdgeType[] edgeTypes;
        private final Vertex vertex;

        EdgeTypeIterable(Vertex vertex, EdgeType ... edgeTypes) {
            this.edgeTypes = edgeTypes;
            this.vertex = vertex;
        }

        @Override
        public Iterator<Edge> iterator() {
            ArrayList<EdgeType> ets = new ArrayList<EdgeType>();
            for (EdgeType edgeType : this.edgeTypes) {
                ets.add(edgeType);
            }
            return new EdgeTypeIterator(ets.iterator(), this.vertex);
        }
    }

    static class ConnectorTypeIterator
    implements Iterator<Edge> {
        private final Iterator<ConnectorType<?>> connectorTypes;
        private final Vertex vertex;
        private final EdgeType edgeType;
        private EdgeIterator currentEdgeIterator = null;
        private Boolean hasNext = null;

        public ConnectorTypeIterator(EdgeType edgeType, Iterator<ConnectorType<?>> connectorTypes, Vertex vertex) {
            this.edgeType = edgeType;
            this.connectorTypes = connectorTypes;
            this.vertex = vertex;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                if (this.currentEdgeIterator == null) {
                    if (this.connectorTypes.hasNext()) {
                        this.currentEdgeIterator = new EdgeIterator(this.edgeType, this.connectorTypes.next(), this.vertex);
                        return this.hasNext();
                    }
                    this.hasNext = false;
                    return false;
                }
                if (this.currentEdgeIterator.hasNext()) {
                    this.hasNext = true;
                    return true;
                }
                this.currentEdgeIterator = null;
                return this.hasNext();
            }
            return this.hasNext;
        }

        @Override
        public Edge next() {
            if (this.hasNext()) {
                this.hasNext = null;
                return this.currentEdgeIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    static class ConnectorTypeIterable
    implements Iterable<Edge> {
        final Iterable<ConnectorType<?>> connectorTypes;
        final EdgeType edgeType;
        private final Vertex vertex;

        public ConnectorTypeIterable(EdgeType edgeType, Iterable<ConnectorType<?>> connectorTypes, Vertex vertex) {
            this.edgeType = edgeType;
            this.connectorTypes = connectorTypes;
            this.vertex = vertex;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new ConnectorTypeIterator(this.edgeType, this.connectorTypes.iterator(), this.vertex);
        }
    }

    static class EdgeIterator
    implements Iterator<Edge> {
        private final Vertex vertex;
        private final Iterator<Relationship> connectorRels;

        public EdgeIterator(EdgeType edgeType, ConnectorType<?> connectorType, Vertex vertex) {
            this.vertex = vertex;
            this.connectorRels = vertex.getNode().getRelationships((RelationshipType)DynamicRelationshipType.withName((String)(edgeType.getName() + VertexImpl.EDGEROLE_SEPARATOR + connectorType.getName())), Direction.INCOMING).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.connectorRels.hasNext();
        }

        @Override
        public Edge next() {
            if (this.connectorRels.hasNext()) {
                return new EdgeImpl(this.vertex.getDb(), this.connectorRels.next().getStartNode().getId());
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

