/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.Iterator;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.impl.BinaryEdgeTypeImpl;
import org.neo4j.graphdb.RelationshipType;

class RelationshipTypeIterator
implements Iterator<EdgeType> {
    private final Iterator<RelationshipType> relTypes;
    private final DatabaseService graphDb;

    RelationshipTypeIterator(Iterator<RelationshipType> relTypes, DatabaseService graphDb) {
        this.relTypes = relTypes;
        this.graphDb = graphDb;
    }

    @Override
    public boolean hasNext() {
        return this.relTypes.hasNext();
    }

    @Override
    public EdgeType next() {
        return BinaryEdgeTypeImpl.getOrCreateInstance(this.graphDb, this.relTypes.next());
    }

    @Override
    public void remove() {
        this.relTypes.remove();
    }
}

