/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.ConnectorTypeDescription;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.impl.ConnectorTypeImpl;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class EdgeTypeImpl
extends VertexTypeImpl
implements EdgeType {
    public EdgeTypeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    private static Class<?> getImplementationClass() {
        try {
            return Class.forName("org.neo4j.collections.graphdb.impl.EdgeTypeImpl");
        }
        catch (ClassNotFoundException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static EdgeTypeImpl getOrCreateInstance(DatabaseService db, String name, ConnectorTypeDescription ... connectorTypeDescriptions) {
        VertexTypeImpl vertexType = new VertexTypeImpl(db, EdgeTypeImpl.getOrCreateByDescriptor(new EdgeTypeNodeDescriptor(db, name, EdgeTypeImpl.getImplementationClass(), connectorTypeDescriptions)).getId());
        return new EdgeTypeImpl(db, vertexType.getNode().getId());
    }

    @Override
    public ConnectorType<?> getConnectorType(String name) {
        for (Relationship rel : this.getNode().getRelationships((RelationshipType)ConnectorTypeImpl.RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE, Direction.OUTGOING)) {
            if (!rel.getEndNode().hasProperty("org.neo4j.collections.graphdb.connector_type_name") || !rel.getEndNode().getProperty("org.neo4j.collections.graphdb.connector_type_name").equals(name)) continue;
            String connectionModeName = (String)rel.getEndNode().getProperty("org.neo4j.collections.graphdb.connector_mode");
            return ConnectorTypeImpl.getOrCreateInstance(this.getDb(), name, this.getNode(), ConnectorTypeImpl.getConnectionMode(connectionModeName));
        }
        return null;
    }

    @Override
    public Iterable<Edge> getEdges(Vertex vertex, ConnectorType<?> ... connectorTypes) {
        HashSet connectorTypes1 = new HashSet();
        Set<ConnectorType<?>> connectorTypes2 = this.getConnectorTypes();
        for (ConnectorType<?> connectorType : connectorTypes) {
            for (ConnectorType<?> connectorType2 : connectorTypes2) {
                if (!connectorType.getName().equals(connectorType2.getName())) continue;
                connectorTypes1.add(connectorType2);
            }
        }
        return new VertexImpl.ConnectorTypeIterable(this, connectorTypes1, vertex);
    }

    @Override
    public Set<ConnectorType<?>> getConnectorTypes() {
        HashSet connectorTypes = new HashSet();
        for (Relationship rel : this.getNode().getRelationships((RelationshipType)ConnectorTypeImpl.RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE, Direction.OUTGOING)) {
            String connectorName = (String)rel.getEndNode().getProperty("org.neo4j.collections.graphdb.connector_type_name");
            ConnectionMode connectionMode = ConnectorTypeImpl.getConnectionMode((String)rel.getEndNode().getProperty("org.neo4j.collections.graphdb.connector_mode"));
            connectorTypes.add(ConnectorTypeImpl.getOrCreateInstance(this.getDb(), connectorName, this.getNode(), connectionMode));
        }
        return connectorTypes;
    }

    @Override
    public boolean hasEdge(Vertex vertex, ConnectorType<?> ... connectorTypes) {
        return this.getEdges(vertex, connectorTypes).iterator().hasNext();
    }

    public static class EdgeTypeNodeDescriptor
    extends VertexTypeImpl.TypeNodeDescriptor {
        private final ConnectorTypeDescription[] connectorTypeDescriptions;

        public EdgeTypeNodeDescriptor(DatabaseService db, String name, Class<?> claz, ConnectorTypeDescription ... connectorTypeDescriptions) {
            super(db, name, claz);
            this.connectorTypeDescriptions = connectorTypeDescriptions;
        }

        @Override
        public void initialize(Node n) {
            super.initialize(n);
            for (ConnectorTypeDescription connectorTypeDescription : this.connectorTypeDescriptions) {
                ConnectorTypeImpl.getOrCreateInstance(this.db, connectorTypeDescription.getName(), n, connectorTypeDescription.getConnectionMode(), connectorTypeDescription.getDomain());
            }
        }
    }
}

