/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.BinaryEdgeType;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.SurjectiveConnectionMode;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.BinaryEdgeImpl;
import org.neo4j.collections.graphdb.impl.ConnectorTypeImpl;
import org.neo4j.collections.graphdb.impl.EdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.RelationshipIterable;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class BinaryEdgeTypeImpl
extends EdgeTypeImpl
implements BinaryEdgeType {
    public static final String STARTCONNECTORNAME = "StartConnector";
    public static final String ENDCONNECTORNAME = "EndConnector";

    public BinaryEdgeTypeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    protected static Class<?> getImplementationClass() {
        try {
            return Class.forName("org.neo4j.collections.graphdb.impl.BinaryEdgeTypeImpl");
        }
        catch (ClassNotFoundException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static BinaryEdgeTypeImpl getOrCreateInstance(DatabaseService db, RelationshipType relType, VertexType domain, VertexType range) {
        VertexTypeImpl vertexType = new VertexTypeImpl(db, BinaryEdgeTypeImpl.getOrCreateByDescriptor(new BinaryEdgeTypeNodeDescriptor(db, relType.name(), BinaryEdgeTypeImpl.getImplementationClass(), domain, range)).getId());
        return new BinaryEdgeTypeImpl(db, vertexType.getNode().getId());
    }

    public static BinaryEdgeTypeImpl getOrCreateInstance(DatabaseService db, RelationshipType relType) {
        VertexTypeImpl vertexType = new VertexTypeImpl(db, BinaryEdgeTypeImpl.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, relType.name(), BinaryEdgeTypeImpl.getImplementationClass())).getId());
        return new BinaryEdgeTypeImpl(db, vertexType.getNode().getId());
    }

    @Override
    public RelationshipType getRelationshipType() {
        return DynamicRelationshipType.withName((String)this.getName());
    }

    @Override
    public Set<ConnectorType<?>> getConnectorTypes() {
        HashSet connectorTypes = new HashSet();
        connectorTypes.add(this.getStartConnectorType());
        connectorTypes.add(this.getEndConnectorType());
        return connectorTypes;
    }

    @Override
    public BinaryEdge createEdge(Vertex startVertex, Vertex endVertex) {
        return new BinaryEdgeImpl(this.db, startVertex.getNode().createRelationshipTo(endVertex.getNode(), this.getRelationshipType()).getId());
    }

    @Override
    public Iterable<BinaryEdge> getEdges(Vertex vertex) {
        return new RelationshipIterable(vertex.getNode().getRelationships(new RelationshipType[]{this.getRelationshipType()}));
    }

    @Override
    public Iterable<BinaryEdge> getEdges(Vertex vertex, Direction dir) {
        return new RelationshipIterable(vertex.getNode().getRelationships(this.getRelationshipType(), dir));
    }

    @Override
    public BinaryEdge getSingleBinaryEdge(Vertex vertex, Direction dir) {
        Relationship rel = vertex.getNode().getSingleRelationship(this.getRelationshipType(), dir);
        if (rel == null) {
            return null;
        }
        return new BinaryEdgeImpl(this.db, rel.getId());
    }

    @Override
    public boolean hasEdge(Vertex vertex, Direction dir) {
        return vertex.getNode().hasRelationship(this.getRelationshipType(), dir);
    }

    @Override
    public ConnectorType<SurjectiveConnectionMode> getStartConnectorType() {
        return ConnectorTypeImpl.getOrCreateInstance(this.db, STARTCONNECTORNAME, this.getNode(), ConnectionMode.SURJECTIVE);
    }

    @Override
    public ConnectorType<SurjectiveConnectionMode> getEndConnectorType() {
        return ConnectorTypeImpl.getOrCreateInstance(this.db, ENDCONNECTORNAME, this.getNode(), ConnectionMode.SURJECTIVE);
    }

    @Override
    public boolean hasEdge(Vertex vertex) {
        return vertex.getNode().hasRelationship(new RelationshipType[]{this.getRelationshipType()});
    }

    public static class BinaryEdgeTypeNodeDescriptor
    extends VertexTypeImpl.TypeNodeDescriptor {
        private final VertexType domain;
        private final VertexType range;

        public BinaryEdgeTypeNodeDescriptor(DatabaseService db, String name, Class<?> claz, VertexType domain, VertexType range) {
            super(db, name, claz);
            this.domain = domain;
            this.range = range;
        }

        @Override
        public void initialize(Node n) {
            super.initialize(n);
            ConnectorTypeImpl.getOrCreateInstance(this.db, BinaryEdgeTypeImpl.STARTCONNECTORNAME, n, ConnectionMode.BIJECTIVE, this.domain);
            ConnectorTypeImpl.getOrCreateInstance(this.db, BinaryEdgeTypeImpl.ENDCONNECTORNAME, n, ConnectionMode.BIJECTIVE, this.range);
        }
    }
}

