/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.neo4j.collections.btree.AbstractBTree;
import org.neo4j.collections.btree.BTree;
import org.neo4j.collections.timeline.TimelineIndex;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.AbstractGraphDatabase;

public class Timeline
implements TimelineIndex {
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMELINE_NAME = "timeline_name";
    private static final String TIMELINE_IS_INDEXED = "timeline_indexed";
    private static final String INDEX_COUNT = "index_count";
    private static int INDEX_TRIGGER_COUNT = 1000;
    private final Node underlyingNode;
    private final boolean indexed;
    private BTree indexBTree;
    private final String name;
    private final GraphDatabaseService graphDb;
    private Node firstNode;
    private Node lastNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeline(String name, Node underlyingNode, boolean indexed, GraphDatabaseService graphDb) {
        if (underlyingNode == null || graphDb == null) {
            throw new IllegalArgumentException("Null parameter underlyingNode=" + underlyingNode + " graphDb=" + graphDb);
        }
        this.underlyingNode = underlyingNode;
        this.graphDb = graphDb;
        org.neo4j.graphdb.Transaction tx = graphDb.beginTx();
        try {
            this.assertPropertyIsSame(TIMELINE_NAME, name);
            this.name = name;
            this.assertPropertyIsSame(TIMELINE_IS_INDEXED, indexed);
            this.indexed = indexed;
            if (indexed) {
                Relationship bTreeRel = underlyingNode.getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.TREE_ROOT, Direction.OUTGOING);
                if (bTreeRel == null) {
                    Node bTreeNode = graphDb.createNode();
                    bTreeRel = underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)AbstractBTree.RelTypes.TREE_ROOT);
                }
                this.indexBTree = new BTree(graphDb, bTreeRel.getEndNode());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public Timeline(String name, Node underlyingNode, boolean indexed, int indexTriggerCount, GraphDatabaseService graphDb) {
        this(name, underlyingNode, indexed, graphDb);
        INDEX_TRIGGER_COUNT = indexTriggerCount;
    }

    private void assertPropertyIsSame(String key, Object value) {
        Object storedValue = this.underlyingNode.getProperty(key, null);
        if (storedValue != null) {
            if (!storedValue.equals(value)) {
                throw new IllegalArgumentException("Timeline(" + this.underlyingNode + ") property '" + key + "' is " + storedValue + ", passed in " + value);
            }
        } else {
            this.underlyingNode.setProperty(key, value);
        }
    }

    public Timeline(String name, Node underlyingNode, GraphDatabaseService graphDb) {
        this(name, underlyingNode, true, graphDb);
    }

    public Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    @Override
    public Node getLastNode() {
        if (this.lastNode != null) {
            return this.lastNode;
        }
        Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
        if (rel == null) {
            return null;
        }
        this.lastNode = ((Relationship)rel.getStartNode().getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING).iterator().next()).getEndNode();
        return this.lastNode;
    }

    @Override
    public Node getFirstNode() {
        if (this.firstNode != null) {
            return this.firstNode;
        }
        Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
        if (rel == null) {
            return null;
        }
        this.firstNode = ((Relationship)rel.getEndNode().getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING).iterator().next()).getEndNode();
        return this.firstNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(Node nodeToAdd, long timestamp) {
        if (nodeToAdd == null) {
            throw new IllegalArgumentException("Null node");
        }
        org.neo4j.graphdb.Transaction tx = this.graphDb.beginTx();
        try {
            for (Relationship rel : nodeToAdd.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                if (!rel.getProperty(TIMELINE_NAME, (Object)"").equals(this.name)) continue;
                throw new IllegalArgumentException("Node[" + nodeToAdd.getId() + "] already connected to Timeline[" + this.name + "]");
            }
            Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
            if (rel == null) {
                Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                this.underlyingNode.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                node.createRelationshipTo(this.underlyingNode, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                this.firstNode = nodeToAdd;
                this.lastNode = nodeToAdd;
                this.updateNodeAdded(timestamp);
            } else {
                Node previousLast = rel.getStartNode();
                long previousTime = (Long)previousLast.getProperty(TIMESTAMP);
                if (timestamp > previousTime) {
                    Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                    rel.delete();
                    previousLast.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    node.createRelationshipTo(this.underlyingNode, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    this.lastNode = nodeToAdd;
                    this.updateNodeAdded(timestamp);
                } else if (timestamp == previousTime) {
                    Relationship instanceRel = previousLast.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                    instanceRel.setProperty(TIMELINE_NAME, (Object)this.name);
                } else {
                    Iterator<Node> itr = this.getAllTimeNodesAfter(timestamp).iterator();
                    assert (itr.hasNext());
                    Node next = itr.next();
                    rel = next.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
                    assert (rel != null);
                    Node previous = rel.getStartNode();
                    long previousTimestamp = Long.MIN_VALUE;
                    if (!previous.equals(this.underlyingNode)) {
                        previousTimestamp = (Long)previous.getProperty(TIMESTAMP);
                    }
                    if (previousTimestamp == timestamp) {
                        Relationship instanceRel = previous.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                        instanceRel.setProperty(TIMELINE_NAME, (Object)this.name);
                        return;
                    }
                    long nextTimestamp = (Long)next.getProperty(TIMESTAMP);
                    if (nextTimestamp == timestamp) {
                        Relationship instanceRel = next.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                        instanceRel.setProperty(TIMELINE_NAME, (Object)this.name);
                        return;
                    }
                    assert (previousTimestamp < timestamp);
                    assert (nextTimestamp > timestamp);
                    Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                    rel.delete();
                    previous.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    node.createRelationshipTo(next, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    if (previous.equals(this.underlyingNode)) {
                        this.firstNode = nodeToAdd;
                    }
                    this.updateNodeAdded(timestamp);
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Node createNewTimeNode(long timestamp, Node nodeToAdd) {
        Node node = this.graphDb.createNode();
        node.setProperty(TIMESTAMP, (Object)timestamp);
        Relationship instanceRel = node.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
        instanceRel.setProperty(TIMELINE_NAME, (Object)this.name);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestampForNode(Node node) {
        org.neo4j.graphdb.Transaction tx = this.graphDb.beginTx();
        try {
            Traverser traverser = node.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

                public boolean isReturnableNode(TraversalPosition position) {
                    Node currentNode = position.currentNode();
                    return currentNode != null && !currentNode.hasRelationship((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.INCOMING);
                }
            }, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.INCOMING);
            Iterator hits = traverser.iterator();
            Long result = null;
            if (!hits.hasNext()) {
                throw new RuntimeException("No timpestamp found for '" + node + "' maybe it's not in the timeline?");
            }
            Node hit = (Node)hits.next();
            result = (Long)hit.getProperty(TIMESTAMP);
            tx.success();
            long l = result;
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private synchronized void updateNodeAdded(long timestamp) {
        if (!this.indexed) {
            return;
        }
        Long nodeId = (Long)this.indexBTree.getClosestHigherEntry(timestamp);
        if (nodeId == null) {
            int indexCount = (Integer)this.underlyingNode.getProperty(INDEX_COUNT, (Object)0);
            if (++indexCount >= INDEX_TRIGGER_COUNT) {
                indexCount = this.createIndex(this.underlyingNode, indexCount);
            }
            this.underlyingNode.setProperty(INDEX_COUNT, (Object)indexCount);
        } else {
            Node indexedNode = this.graphDb.getNodeById(nodeId.longValue());
            int indexCount = (Integer)indexedNode.getProperty(INDEX_COUNT);
            if (++indexCount >= INDEX_TRIGGER_COUNT) {
                indexCount = this.createIndex(indexedNode, indexCount);
            }
            indexedNode.setProperty(INDEX_COUNT, (Object)indexCount);
        }
    }

    private int createIndex(Node startIndexNode, int currentCount) {
        assert (this.indexed);
        int newCount = 0;
        int timesToTraverse = (int)((float)INDEX_TRIGGER_COUNT * 0.33f);
        assert (timesToTraverse > 0);
        Node newIndexedNode = startIndexNode;
        for (int i = 0; i < timesToTraverse; ++i) {
            newIndexedNode = newIndexedNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING).getStartNode();
            ++newCount;
            assert (!newIndexedNode.hasProperty(INDEX_COUNT));
        }
        long timestamp = (Long)newIndexedNode.getProperty(TIMESTAMP);
        this.indexBTree.addEntry(timestamp, newIndexedNode.getId());
        newIndexedNode.setProperty(INDEX_COUNT, (Object)(currentCount - timesToTraverse));
        return newCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node nodeToRemove, boolean transactional) {
        if (nodeToRemove == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        if (nodeToRemove.equals(this.underlyingNode)) {
            throw new IllegalArgumentException("Cannot remove underlying node");
        }
        org.neo4j.graphdb.Transaction tx = this.graphDb.beginTx();
        try {
            Relationship instanceRel = null;
            for (Relationship rel : nodeToRemove.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                if (!rel.getProperty(TIMELINE_NAME, (Object)"").equals(this.name)) continue;
                assert (instanceRel == null);
                instanceRel = rel;
            }
            if (instanceRel == null) {
                throw new IllegalArgumentException("Node[" + nodeToRemove.getId() + "] not added to Timeline[" + this.name + "]");
            }
            Node node = instanceRel.getStartNode();
            instanceRel.delete();
            if (this.firstNode != null && this.firstNode.equals(nodeToRemove)) {
                this.firstNode = null;
            }
            if (this.lastNode != null && this.lastNode.equals(nodeToRemove)) {
                this.lastNode = null;
            }
            if (node.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE}).iterator().hasNext()) {
                return;
            }
            Relationship incoming = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
            if (incoming == null) {
                throw new RuntimeException("No incoming relationship of " + (Object)((Object)RelTypes.TIMELINE_NEXT_ENTRY) + " found");
            }
            Relationship outgoing = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
            if (outgoing == null) {
                throw new RuntimeException("No outgoing relationship of " + (Object)((Object)RelTypes.TIMELINE_NEXT_ENTRY) + " found");
            }
            Node previous = incoming.getStartNode();
            Node next = outgoing.getEndNode();
            incoming.delete();
            outgoing.delete();
            if (node.hasProperty(INDEX_COUNT)) {
                long nodeId = (Long)this.indexBTree.removeEntry((Long)node.getProperty(TIMESTAMP));
                assert (nodeId == node.getId());
                int count = (Integer)node.getProperty(INDEX_COUNT);
                --count;
                if (!previous.equals(this.underlyingNode) && !previous.hasProperty(INDEX_COUNT)) {
                    previous.setProperty(INDEX_COUNT, (Object)count);
                    this.indexBTree.addEntry((Long)previous.getProperty(TIMESTAMP), previous.getId());
                }
            } else {
                long timestamp = (Long)node.getProperty(TIMESTAMP);
                if (this.indexed) {
                    Long nodeId = (Long)this.indexBTree.getClosestHigherEntry(timestamp);
                    if (nodeId != null) {
                        Node indexedNode = this.graphDb.getNodeById(nodeId.longValue());
                        int count = (Integer)indexedNode.getProperty(INDEX_COUNT);
                        indexedNode.setProperty(INDEX_COUNT, (Object)(--count));
                    } else if (this.underlyingNode.hasProperty(INDEX_COUNT)) {
                        int count = (Integer)this.underlyingNode.getProperty(INDEX_COUNT);
                        this.underlyingNode.setProperty(INDEX_COUNT, (Object)(--count));
                    }
                }
            }
            node.delete();
            if (!previous.equals(next)) {
                previous.createRelationshipTo(next, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
            }
            tx.success();
        }
        finally {
            if (transactional) {
                tx.finish();
            }
        }
    }

    @Override
    public void removeNode(Node nodeToRemove) {
        this.removeNode(nodeToRemove, true);
    }

    @Override
    public Iterable<Node> getAllNodes(Long afterTimestampOrNull, Long beforeTimestampOrNull) {
        Iterable<Node> result = null;
        result = afterTimestampOrNull == null && beforeTimestampOrNull == null ? this.getAllNodes() : (afterTimestampOrNull == null ? this.getAllNodesBefore(beforeTimestampOrNull) : (beforeTimestampOrNull == null ? this.getAllNodesAfter(afterTimestampOrNull) : this.getAllNodesBetween(afterTimestampOrNull, beforeTimestampOrNull)));
        return result;
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.underlyingNode.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                return last != null && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
    }

    Iterable<Node> getAllTimeNodes() {
        return this.underlyingNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                return position.depth() > 0;
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
    }

    private Node getIndexedStartNode(long timestamp) {
        if (this.indexed) {
            Node startNode = this.underlyingNode;
            Long nodeId = (Long)this.indexBTree.getClosestLowerEntry(timestamp);
            if (nodeId != null) {
                startNode = this.graphDb.getNodeById(nodeId.longValue());
            }
            return startNode;
        }
        return this.underlyingNode;
    }

    @Override
    public Iterable<Node> getNodes(long timestamp) {
        Relationship rel;
        long currentTime;
        Node currentNode = this.getIndexedStartNode(timestamp);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (currentNode.equals(this.underlyingNode)) {
            if (!currentNode.hasRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING)) {
                return nodeList;
            }
            currentNode = currentNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING).getEndNode();
        }
        do {
            if ((currentTime = ((Long)currentNode.getProperty(TIMESTAMP)).longValue()) != timestamp) continue;
            for (Relationship instanceRel : currentNode.getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING)) {
                nodeList.add(instanceRel.getEndNode());
            }
            break;
        } while (currentTime <= timestamp && !(currentNode = (rel = currentNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING)).getEndNode()).equals(this.underlyingNode));
        return nodeList;
    }

    @Override
    public Iterable<Node> getAllNodesAfter(final long timestamp) {
        Node startNode = this.getIndexedStartNode(timestamp);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.lastRelationshipTraversed() != null && position.currentNode().equals(Timeline.this.underlyingNode);
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > timestamp;
                    return false;
                }
                return this.timeOk && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    Iterable<Node> getAllTimeNodesAfter(final long timestamp) {
        Node startNode = this.getIndexedStartNode(timestamp);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.lastRelationshipTraversed() != null && position.currentNode().equals(Timeline.this.underlyingNode);
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > timestamp;
                }
                return this.timeOk;
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
    }

    @Override
    public Iterable<Node> getAllNodesBefore(final long timestamp) {
        return this.underlyingNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                if (last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    return currentTime >= timestamp;
                }
                return false;
            }
        }, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                return last != null && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    @Override
    public Iterable<Node> getAllNodesBetween(final long startTime, final long endTime) {
        if (startTime >= endTime) {
            throw new IllegalArgumentException("Start time greater or equal to end time");
        }
        Node startNode = this.getIndexedStartNode(startTime);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                if (last != null && position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return true;
                }
                if (last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    return currentTime >= endTime;
                }
                return false;
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > startTime;
                    return false;
                }
                return this.timeOk && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    @Override
    public void delete() {
        if (this.indexed) {
            this.indexBTree.delete();
        }
        Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
        while (rel != null) {
            Node node = rel.getEndNode();
            if (!node.equals(this.underlyingNode)) {
                for (Relationship instance : node.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                    instance.delete();
                }
                rel.delete();
                rel = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
                node.delete();
                continue;
            }
            rel.delete();
            rel = null;
        }
    }

    public void delete(int commitInterval) {
        int count = 0;
        while (this.getLastNode() != null) {
            this.removeNode(this.getLastNode());
            if (++count <= commitInterval) continue;
            System.out.print(".");
            this.restartTx();
            count = 0;
        }
        if (this.indexed) {
            this.indexBTree.delete(commitInterval);
        }
    }

    private void restartTx() {
        try {
            Transaction tx = ((AbstractGraphDatabase)this.graphDb).getConfig().getTxModule().getTxManager().getTransaction();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.graphDb.beginTx();
    }

    static enum RelTypes implements RelationshipType
    {
        TIMELINE_INSTANCE,
        TIMELINE_NEXT_ENTRY;

    }
}

