/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.sortedtree;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.collections.GraphCollection;
import org.neo4j.collections.sortedtree.SortedTree;
import org.neo4j.collections.sortedtree.TempRelationship;
import org.neo4j.collections.sortedtree.TreeNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

class NodeEntry {
    static final String NODE_ID = "node_id";
    private Relationship entryRelationship;
    private TreeNode treeNode;

    NodeEntry(TreeNode treeNode, Relationship underlyingRelationship) {
        assert (treeNode != null);
        assert (underlyingRelationship != null);
        this.treeNode = treeNode;
        this.entryRelationship = underlyingRelationship;
    }

    Relationship getUnderlyingRelationship() {
        return this.entryRelationship;
    }

    TreeNode getTreeNode() {
        return this.treeNode;
    }

    private SortedTree getBTree() {
        return this.treeNode.getBTree();
    }

    TreeNode getBeforeSubTree() {
        Relationship subTreeRel = this.getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    TreeNode getAfterSubTree() {
        Relationship subTreeRel = this.getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    NodeEntry getNextKey() {
        Relationship nextKeyRel = this.getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextKeyRel != null) {
            return new NodeEntry(this.getTreeNode(), nextKeyRel);
        }
        return null;
    }

    NodeEntry getPreviousKey() {
        Relationship prevKeyRel = this.getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevKeyRel != null) {
            return new NodeEntry(this.getTreeNode(), prevKeyRel);
        }
        return null;
    }

    public String toString() {
        return "Entry[" + this.getNodes() + "]";
    }

    boolean isLeaf() {
        if (this.getUnderlyingRelationship().getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null) {
            assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null);
            return false;
        }
        assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING) == null);
        return true;
    }

    Node getANode() {
        Iterable rels = this.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING);
        Iterator i$ = rels.iterator();
        if (i$.hasNext()) {
            Relationship rel = (Relationship)i$.next();
            return rel.getEndNode();
        }
        throw new RuntimeException("Key entry is empty");
    }

    Iterable<Node> getNodes() {
        return new NodeIterable();
    }

    Iterable<Relationship> getRelationships() {
        return new RelationshipIterable();
    }

    Relationship addNode(Node node) {
        Relationship rel = this.getEndNode().createRelationshipTo(node, (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
        String treeName = this.treeNode.getBTree().getTreeName();
        if (treeName != null) {
            rel.setProperty("tree_name", (Object)treeName);
        }
        return rel;
    }

    Node getStartNode() {
        return this.entryRelationship.getStartNode();
    }

    Node getEndNode() {
        return this.entryRelationship.getEndNode();
    }

    void move(TreeNode node, Node startNode, Node endNode) {
        assert (node != null);
        this.treeNode = node;
        ArrayList<TempRelationship> trls = new ArrayList<TempRelationship>();
        for (Relationship rel : this.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            trls.add(new TempRelationship(rel));
            rel.delete();
        }
        this.entryRelationship.delete();
        this.entryRelationship = startNode.createRelationshipTo(endNode, (RelationshipType)SortedTree.RelTypes.KEY_ENTRY);
        for (TempRelationship trl : trls) {
            Relationship rel = this.getEndNode().createRelationshipTo(trl.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
            for (String key : trl.getProperties().keySet()) {
                rel.setProperty(key, trl.getProperties().get(key));
            }
        }
    }

    class RelationshipIterable
    implements Iterable<Relationship> {
        RelationshipIterable() {
        }

        @Override
        public Iterator<Relationship> iterator() {
            return NodeEntry.this.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING).iterator();
        }
    }

    class NodeIterable
    implements Iterable<Node> {
        NodeIterable() {
        }

        @Override
        public Iterator<Node> iterator() {
            Iterable rels = NodeEntry.this.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING);
            return new NodeIterator(rels.iterator());
        }
    }

    class NodeIterator
    implements Iterator<Node> {
        Iterator<Relationship> rels;

        NodeIterator(Iterator<Relationship> rels) {
            this.rels = rels;
        }

        @Override
        public boolean hasNext() {
            return this.rels.hasNext();
        }

        @Override
        public Node next() {
            return this.rels.next().getEndNode();
        }

        @Override
        public void remove() {
            this.rels.remove();
        }
    }
}

