/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.rtree;

public class Envelope {
    private double[] min;
    private double[] max;

    public Envelope(Envelope e) {
        this(e.min, e.max);
    }

    public Envelope(double[] min, double[] max) {
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        if (!this.isValid()) {
            throw new RuntimeException("Invalid envelope created " + this.toString());
        }
    }

    public Envelope(double[] p) {
        this.min = (double[])p.clone();
        this.max = (double[])p.clone();
    }

    public Envelope(double xmin, double xmax, double ymin, double ymax) {
        this(new double[]{xmin, ymin}, new double[]{xmax, ymax});
    }

    public Envelope() {
    }

    public double getMin(int dimension) {
        return this.min[dimension];
    }

    public double getMax(int dimension) {
        return this.max[dimension];
    }

    public double getMinX() {
        return this.getMin(0);
    }

    public double getMaxX() {
        return this.getMax(0);
    }

    public double getMinY() {
        return this.getMin(1);
    }

    public double getMaxY() {
        return this.getMax(1);
    }

    public int getDimension() {
        return this.isValid() ? this.min.length : 0;
    }

    public boolean contains(Envelope other) {
        return this.covers(other);
    }

    public boolean covers(Envelope other) {
        boolean ans = this.isValid() && other.isValid() && this.getDimension() == other.getDimension();
        for (int i = 0; i < this.min.length; ++i) {
            if (!ans) {
                return ans;
            }
            ans = ans && other.min[i] >= this.min[i] && other.max[i] <= this.max[i];
        }
        return ans;
    }

    public boolean disjoint(Envelope other) {
        if (this.isValid() && other.isValid() && this.getDimension() == other.getDimension()) {
            return !this.intersects(other);
        }
        return false;
    }

    public boolean intersects(Envelope other) {
        if (this.isValid() && other.isValid() && this.getDimension() == other.getDimension()) {
            boolean result = false;
            for (int i = 0; i < this.min.length; ++i) {
                result = result || !(other.min[i] > this.max[i]) && !(other.max[i] < this.min[i]);
            }
            return result;
        }
        return false;
    }

    public void expandToInclude(Envelope other) {
        if (!this.isValid()) {
            this.min = (double[])other.min.clone();
            this.max = (double[])other.max.clone();
        } else {
            for (int i = 0; i < this.min.length; ++i) {
                if (other.min[i] < this.min[i]) {
                    this.min[i] = other.min[i];
                }
                if (!(other.max[i] > this.max[i])) continue;
                this.max[i] = other.max[i];
            }
        }
    }

    public void expandBy(double[] padding) {
        for (int i = 0; i < this.min.length; ++i) {
            int n = i;
            this.min[n] = this.min[n] - padding[i];
            int n2 = i;
            this.max[n2] = this.max[n2] + padding[i];
        }
    }

    public double[] centre() {
        if (!this.isValid()) {
            return null;
        }
        double[] center = new double[this.min.length];
        for (int i = 0; i < this.min.length; ++i) {
            center[i] = (this.min[i] + this.max[i]) / 2.0;
        }
        return center;
    }

    public double distance(Envelope other, int dimension) {
        if (this.min[dimension] < other.min[dimension]) {
            return other.min[dimension] - this.max[dimension];
        }
        return this.min[dimension] - other.max[dimension];
    }

    public double distance(Envelope other) {
        if (this.intersects(other)) {
            return 0.0;
        }
        double distance = 0.0;
        for (int i = 0; i < this.min.length; ++i) {
            double dist = this.distance(other, i);
            if (!(dist > 0.0)) continue;
            distance += dist * dist;
        }
        return Math.sqrt(distance);
    }

    public void expandToInclude(double[] p) {
        if (!this.isValid()) {
            this.min = (double[])p.clone();
            this.max = (double[])p.clone();
        } else {
            for (int i = 0; i < Math.min(p.length, this.min.length); ++i) {
                if (p[i] < this.min[i]) {
                    this.min[i] = p[i];
                }
                if (!(p[i] > this.max[i])) continue;
                this.max[i] = p[i];
            }
        }
    }

    public void expandToInclude(double x, double y) {
        this.expandToInclude(new double[]{x, y});
    }

    public double getHeight() {
        return this.getWidth(1);
    }

    public double getWidth() {
        return this.getWidth(0);
    }

    public double getWidth(int dimension) {
        return this.isValid() ? this.max[dimension] - this.min[dimension] : 0.0;
    }

    public double getArea() {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            area *= this.max[i] - this.min[i];
        }
        return area;
    }

    public boolean isValid() {
        boolean ans;
        boolean bl = ans = this.min != null && this.max != null && this.min.length == this.max.length;
        if (!ans) {
            return ans;
        }
        for (int i = 0; i < this.min.length; ++i) {
            boolean bl2 = ans = ans && this.min[i] <= this.max[i];
            if (ans) continue;
            return ans;
        }
        return ans;
    }

    public void translate(double[] offset) {
        for (int i = 0; i < Math.min(offset.length, this.min.length); ++i) {
            int n = i;
            this.min[n] = this.min[n] + offset[i];
            int n2 = i;
            this.max[n2] = this.max[n2] + offset[i];
        }
    }

    public String toString() {
        return "Envelope: min=" + Envelope.makeString(this.min) + ", max=" + Envelope.makeString(this.max);
    }

    private static String makeString(double[] vals) {
        StringBuffer sb = new StringBuffer();
        if (vals == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < vals.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                } else {
                    sb.append("(");
                }
                sb.append(vals[i]);
            }
            if (sb.length() > 0) {
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

