/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

class List
implements java.util.List<Node> {
    protected Node underlyingNode;
    protected GraphDatabaseService graphDb;
    private List outer = this;
    static final String INDEX_SIZE = "index_size";

    public List(Node listNode, GraphDatabaseService graphDb) {
        this.graphDb = graphDb;
        this.underlyingNode = listNode;
    }

    @Override
    public void add(int index, Node element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Relationship currentEntryRelation = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING);
        Node currentEntry = currentEntryRelation.getEndNode();
        if (index == 0) {
            currentEntryRelation.delete();
            Node newEntry = this.graphDb.createNode();
            this.underlyingNode.createRelationshipTo(newEntry, (RelationshipType)RelTypes.FIRST_ELEMENT);
            newEntry.createRelationshipTo(currentEntry, (RelationshipType)RelTypes.NEXT_ELEMENT);
            newEntry.createRelationshipTo(element, (RelationshipType)RelTypes.LIST_ENTRY);
            this.underlyingNode.setProperty(INDEX_SIZE, (Object)1);
        } else {
            for (int i = 0; i < index; ++i) {
                currentEntryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
                currentEntry = currentEntryRelation.getEndNode();
            }
            Node prevEntry = currentEntryRelation.getStartNode();
            currentEntryRelation.delete();
            Node newEntry = this.graphDb.createNode();
            prevEntry.createRelationshipTo(newEntry, (RelationshipType)RelTypes.NEXT_ELEMENT);
            newEntry.createRelationshipTo(currentEntry, (RelationshipType)RelTypes.NEXT_ELEMENT);
            newEntry.createRelationshipTo(element, (RelationshipType)RelTypes.LIST_ENTRY);
            int i = (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
            this.underlyingNode.setProperty(INDEX_SIZE, (Object)(i + 1));
        }
    }

    @Override
    public boolean add(Node e) {
        Node entry = this.graphDb.createNode();
        entry.createRelationshipTo(e, (RelationshipType)RelTypes.LIST_ENTRY);
        if (this.isEmpty()) {
            this.underlyingNode.createRelationshipTo(entry, (RelationshipType)RelTypes.FIRST_ELEMENT);
            this.underlyingNode.createRelationshipTo(entry, (RelationshipType)RelTypes.LAST_ELEMENT);
            this.underlyingNode.setProperty(INDEX_SIZE, (Object)1);
        } else {
            Relationship lastElementRelation = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.LAST_ELEMENT, Direction.OUTGOING);
            Node lastElement = lastElementRelation.getEndNode();
            lastElementRelation.delete();
            lastElement.createRelationshipTo(entry, (RelationshipType)RelTypes.NEXT_ELEMENT);
            this.underlyingNode.createRelationshipTo(entry, (RelationshipType)RelTypes.LAST_ELEMENT);
            int i = (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
            this.underlyingNode.setProperty(INDEX_SIZE, (Object)(i + 1));
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Node> c) {
        for (Node node : c) {
            this.add(node);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends Node> c) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Node firstElement = null;
        Node lastElement = null;
        for (Node node : c) {
            Node element = this.graphDb.createNode();
            if (firstElement == null) {
                firstElement = element;
                lastElement = element;
            } else {
                lastElement.createRelationshipTo(element, (RelationshipType)RelTypes.NEXT_ELEMENT);
                lastElement = element;
            }
            element.createRelationshipTo(node, (RelationshipType)RelTypes.LIST_ENTRY);
        }
        if (firstElement != null) {
            Relationship currentEntryRelation = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING);
            Node node = currentEntryRelation.getEndNode();
            if (index == 0) {
                currentEntryRelation.delete();
                this.underlyingNode.createRelationshipTo(firstElement, (RelationshipType)RelTypes.FIRST_ELEMENT);
                lastElement.createRelationshipTo(node, (RelationshipType)RelTypes.NEXT_ELEMENT);
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)(this.size() + c.size()));
            } else {
                void var6_8;
                for (int i = 0; i < index; ++i) {
                    currentEntryRelation = var6_8.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
                    Node node2 = currentEntryRelation.getEndNode();
                }
                Node prevEntry = currentEntryRelation.getStartNode();
                currentEntryRelation.delete();
                prevEntry.createRelationshipTo(firstElement, (RelationshipType)RelTypes.NEXT_ELEMENT);
                lastElement.createRelationshipTo((Node)var6_8, (RelationshipType)RelTypes.NEXT_ELEMENT);
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)(this.size() + c.size()));
            }
        }
        return true;
    }

    @Override
    public void clear() {
        Iterator<Node> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Node) {
            for (Node node : this) {
                if (((Node)o).getId() != node.getId()) continue;
                return true;
            }
            return false;
        }
        throw new ClassCastException("Supplied object is not a Node");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public void delete() {
        this.clear();
        this.underlyingNode.removeProperty(INDEX_SIZE);
        this.underlyingNode.delete();
    }

    @Override
    public Node get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Iterator<Node> it = this.iterator();
        for (int i = 0; i < this.size(); ++i) {
            Node n = it.next();
            if (i != index) continue;
            return n;
        }
        throw new IndexOutOfBoundsException();
    }

    public Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Node) {
            int i = 0;
            for (Node node : this) {
                if (((Node)o).getId() == node.getId()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        throw new ClassCastException("Supplied object is not a Node");
    }

    @Override
    public boolean isEmpty() {
        return !this.underlyingNode.hasRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING);
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator(-1);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Node) {
            int i = this.size() - 1;
            for (Node node : new ReverseList()) {
                if (((Node)o).getId() == node.getId()) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        throw new ClassCastException("Supplied object is not a Node");
    }

    @Override
    public ListIterator<Node> listIterator() {
        return new NodeListIterator(-1);
    }

    @Override
    public ListIterator<Node> listIterator(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new NodeListIterator(index);
    }

    @Override
    public Node remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Relationship currentEntryRelation = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING);
        Node currentEntry = currentEntryRelation.getEndNode();
        Node currentNode = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
        Relationship lastEntryRelation = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.LAST_ELEMENT, Direction.OUTGOING);
        Node lastEntry = lastEntryRelation.getEndNode();
        if (index == 0) {
            currentEntryRelation.delete();
            if (currentEntry.getId() == lastEntry.getId()) {
                lastEntryRelation.delete();
                Relationship entryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING);
                entryRelation.delete();
                currentEntry.delete();
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)0);
            } else {
                Relationship nextEntryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
                Node nextEntry = nextEntryRelation.getEndNode();
                nextEntryRelation.delete();
                Relationship entryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING);
                entryRelation.delete();
                currentEntry.delete();
                this.underlyingNode.createRelationshipTo(nextEntry, (RelationshipType)RelTypes.FIRST_ELEMENT);
                int i = (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)(i - 1));
            }
        } else {
            for (int i = 0; i < index; ++i) {
                currentEntryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
                currentEntry = currentEntryRelation.getEndNode();
            }
            currentNode = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
            Node prevEntry = currentEntryRelation.getStartNode();
            currentEntryRelation.delete();
            if (currentEntry.getId() == lastEntry.getId()) {
                lastEntryRelation.delete();
                this.underlyingNode.createRelationshipTo(prevEntry, (RelationshipType)RelTypes.LAST_ELEMENT);
                Relationship entryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING);
                entryRelation.delete();
                currentEntry.delete();
                int i = (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)(i - 1));
            } else {
                Relationship nextEntryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
                Node nextEntry = nextEntryRelation.getEndNode();
                nextEntryRelation.delete();
                Relationship entryRelation = currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING);
                entryRelation.delete();
                currentEntry.delete();
                prevEntry.createRelationshipTo(nextEntry, (RelationshipType)RelTypes.NEXT_ELEMENT);
                int i = (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
                this.underlyingNode.setProperty(INDEX_SIZE, (Object)(i - 1));
            }
        }
        return currentNode;
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.indexOf(o);
        if (idx >= 0) {
            this.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!(o instanceof Node)) continue;
            changed = true;
            this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<Node> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            changed = true;
            i.remove();
        }
        return changed;
    }

    @Override
    public Node set(int index, Node element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Node currentEntry = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING).getEndNode();
        for (int i = 0; i < index; ++i) {
            currentEntry = currentEntry.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING).getEndNode();
        }
        currentEntry.getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).delete();
        currentEntry.createRelationshipTo(element, (RelationshipType)RelTypes.LIST_ENTRY);
        return element;
    }

    @Override
    public int size() {
        if (this.underlyingNode.hasProperty(INDEX_SIZE)) {
            return (Integer)this.underlyingNode.getProperty(INDEX_SIZE);
        }
        this.underlyingNode.setProperty(INDEX_SIZE, (Object)0);
        return 0;
    }

    @Override
    public java.util.List<Node> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] nodeArray = new Node[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            nodeArray[i] = this.get(i);
        }
        return nodeArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a instanceof Node[]) {
            if (a.length < this.size()) {
                return this.toArray();
            }
            for (int i = 0; i < a.length; ++i) {
                a[i] = i <= this.size() ? this.get(i) : null;
            }
            return a;
        }
        throw new ArrayStoreException();
    }

    class ReverseNodeIterator
    extends ReverseElementIterator {
        ReverseNodeIterator() {
        }

        @Override
        public Node next() {
            return super.next().getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
        }
    }

    class ReverseList
    implements Iterable<Node> {
        ReverseList() {
        }

        @Override
        public Iterator<Node> iterator() {
            return new ReverseNodeIterator();
        }
    }

    class ReverseElementIterator
    implements Iterator<Node> {
        protected Node currentElement;

        ReverseElementIterator() {
            this.currentElement = List.this.underlyingNode;
        }

        @Override
        public boolean hasNext() {
            if (this.currentElement.getId() == List.this.underlyingNode.getId()) {
                return this.currentElement.hasRelationship((RelationshipType)RelTypes.LAST_ELEMENT, Direction.OUTGOING);
            }
            return this.currentElement.hasRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.INCOMING);
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentElement = this.currentElement.getId() == List.this.underlyingNode.getId() ? List.this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.LAST_ELEMENT, Direction.OUTGOING).getEndNode() : this.currentElement.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.INCOMING).getStartNode();
            return this.currentElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum RelTypes implements RelationshipType
    {
        FIRST_ELEMENT,
        LAST_ELEMENT,
        NEXT_ELEMENT,
        LIST_ENTRY;

    }

    class NodeListIterator
    extends ElementListIterator {
        NodeListIterator(int index) {
            super(index);
        }

        @Override
        public Node next() {
            return super.next().getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
        }

        @Override
        public Node previous() {
            return super.previous().getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
        }
    }

    class NodeIterator
    extends ElementIterator {
        NodeIterator(int index) {
            super(index);
        }

        @Override
        public Node next() {
            return super.next().getSingleRelationship((RelationshipType)RelTypes.LIST_ENTRY, Direction.OUTGOING).getEndNode();
        }
    }

    class ElementListIterator
    extends ElementIterator
    implements ListIterator<Node> {
        ElementListIterator(int index) {
            super(index);
        }

        @Override
        public void add(Node e) {
            List.this.outer.add(this.index, e);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(Node e) {
            List.this.outer.set(this.index, e);
        }
    }

    class ElementIterator
    implements Iterator<Node> {
        protected Node currentElement;
        protected int index;

        ElementIterator(int index) {
            this.currentElement = List.this.underlyingNode;
            this.index = -1;
            if (index > -1) {
                this.currentElement = List.this.outer.get(index);
                this.index = index;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentElement.getId() == List.this.underlyingNode.getId()) {
                return this.currentElement.hasRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING);
            }
            return this.currentElement.hasRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING);
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentElement = this.currentElement.getId() == List.this.underlyingNode.getId() ? List.this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.FIRST_ELEMENT, Direction.OUTGOING).getEndNode() : this.currentElement.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.OUTGOING).getEndNode();
            ++this.index;
            return this.currentElement;
        }

        public boolean hasPrevious() {
            if (this.currentElement == List.this.underlyingNode) {
                return false;
            }
            return this.currentElement.hasRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.INCOMING);
        }

        public Node previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.currentElement = this.currentElement.getSingleRelationship((RelationshipType)RelTypes.NEXT_ELEMENT, Direction.INCOMING).getStartNode();
            --this.index;
            return this.currentElement;
        }

        @Override
        public void remove() {
            if (this.hasPrevious()) {
                this.previous();
                List.this.outer.remove(this.index + 1);
            } else {
                List.this.outer.remove(this.index);
                this.currentElement = List.this.underlyingNode;
                this.index = -1;
            }
        }
    }
}

