/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collections.graphdb.Connection;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.Connector;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.LeftRestrictedConnectionMode;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.GraphDatabaseImpl;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class EdgeImpl
extends VertexImpl
implements Edge {
    Edge outer = this;
    private EdgeType relType;

    EdgeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    @Override
    public void delete() {
        this.getNode().delete();
    }

    @Override
    public Iterable<Connector<?>> getConnectors() {
        return new ConnectorIterable();
    }

    @Override
    public Iterable<Connector<?>> getConnectors(ConnectorType<?> ... connectorTypes) {
        HashSet connectorSet = new HashSet();
        for (ConnectorType<?> connectorType : connectorTypes) {
            Connector<?> er = Connector.getInstance(connectorType, this.outer);
            connectorSet.add(er);
        }
        return new ConnectorIterable(connectorSet);
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getNode();
    }

    @Override
    protected VertexType getSpecialVertexType() {
        return this.getType();
    }

    @Override
    public EdgeType getType() {
        if (this.relType == null) {
            this.relType = (EdgeType)this.getDb().getVertex(this.getDb().getNodeById((Long)this.getNode().getProperty(GraphDatabaseImpl.EDGE_TYPE)));
        }
        return this.relType;
    }

    public <U extends LeftRestrictedConnectionMode> Vertex getVertex(ConnectorType<U> connectorType) {
        Relationship rel = this.getNode().getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)(this.getType().getName() + "/#/" + connectorType.getName())), Direction.OUTGOING);
        return this.getDb().getVertex(rel.getEndNode());
    }

    @Override
    public <T extends ConnectionMode> Iterable<Vertex> getVertices(ConnectorType<T> connectorType) {
        return new ElementIterable(connectorType);
    }

    @Override
    public boolean isType(EdgeType relType) {
        return relType.getNode().getId() == this.getType().getNode().getId();
    }

    @Override
    public <T extends ConnectionMode> Iterable<Connection<T>> getConnections(ConnectorType<T> connectorType) {
        Connector<T> connector = this.getConnector(connectorType);
        return connector.getConnections();
    }

    @Override
    public <T extends ConnectionMode> Connector<T> getConnector(ConnectorType<T> connectorType) {
        Iterator<Connector<?>> i$ = this.getConnectors(connectorType).iterator();
        if (i$.hasNext()) {
            Connector<?> connector = i$.next();
            return connector;
        }
        return null;
    }

    private class ConnectorIterable
    implements Iterable<Connector<?>> {
        private final Set<Connector<?>> connectors;

        public ConnectorIterable() {
            this.connectors = new HashSet();
            for (ConnectorType<?> connectorType : EdgeImpl.this.getType().getConnectorTypes()) {
                this.connectors.add(Connector.getInstance(connectorType, EdgeImpl.this.outer));
            }
        }

        public ConnectorIterable(Set<Connector<?>> connectors) {
            this.connectors = connectors;
        }

        @Override
        public Iterator<Connector<?>> iterator() {
            return this.connectors.iterator();
        }
    }

    private class ElementIterator
    implements Iterator<Vertex> {
        private final Iterator<Relationship> rels;

        public ElementIterator(ConnectorType<?> connectorType) {
            this.rels = EdgeImpl.this.getNode().getRelationships((RelationshipType)DynamicRelationshipType.withName((String)(EdgeImpl.this.getType().getName() + "/#/" + connectorType.getName())), Direction.OUTGOING).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rels.hasNext();
        }

        @Override
        public Vertex next() {
            Vertex elem = EdgeImpl.this.getDb().getVertex(this.rels.next().getEndNode());
            return elem;
        }

        @Override
        public void remove() {
        }
    }

    private class ElementIterable
    implements Iterable<Vertex> {
        private final ConnectorType<?> connectorType;

        public ElementIterable(ConnectorType<?> connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public Iterator<Vertex> iterator() {
            return new ElementIterator(this.connectorType);
        }
    }
}

