/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.ArrayList;
import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.BinaryEdgeType;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.Connector;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.LeftRestrictedConnectionMode;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.BinaryEdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.EdgeImpl;
import org.neo4j.collections.graphdb.impl.GraphDatabaseImpl;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class BinaryEdgeImpl
extends EdgeImpl
implements BinaryEdge {
    private Node node;
    public static String NODE_ID = "org.neo4j.collections.graphdb.node_id";
    public static String REL_ID = "org.neo4j.collections.graphdb.rel_id";

    BinaryEdgeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    @Override
    public void delete() {
        this.getRelationship().delete();
        if (this.node != null) {
            this.node.delete();
        }
    }

    @Override
    public Relationship getRelationship() {
        return this.db.getRelationshipById(this.id);
    }

    @Override
    protected VertexType getSpecialVertexType() {
        return this.getType();
    }

    @Override
    public BinaryEdgeType getType() {
        return BinaryEdgeTypeImpl.getOrCreateInstance(this.getDb(), this.getRelationship().getType());
    }

    @Override
    public boolean isType(EdgeType relType) {
        return this.getRelationship().isType((RelationshipType)DynamicRelationshipType.withName((String)relType.getName()));
    }

    @Override
    public DatabaseService getDb() {
        return new GraphDatabaseImpl(this.getRelationship().getGraphDatabase());
    }

    @Override
    public Node getNode() {
        if (this.node == null) {
            if (this.getRelationship().hasProperty(NODE_ID)) {
                this.node = this.getDb().getGraphDatabaseService().getNodeById(((Long)this.getRelationship().getProperty(NODE_ID)).longValue());
            } else {
                this.node = this.getDb().getGraphDatabaseService().createNode();
                this.node.setProperty(REL_ID, (Object)this.getRelationship().getId());
                this.getRelationship().setProperty(NODE_ID, (Object)this.node.getId());
            }
        }
        return this.node;
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getRelationship();
    }

    @Override
    public Iterable<Connector<?>> getConnectors() {
        ArrayList connectors = new ArrayList();
        connectors.add(Connector.getInstance(this.getType().getStartConnectorType(), this));
        connectors.add(Connector.getInstance(this.getType().getEndConnectorType(), this));
        return connectors;
    }

    @Override
    public <T extends ConnectionMode> Iterable<Vertex> getVertices(ConnectorType<T> connectorType) {
        ArrayList<Vertex> elements = new ArrayList<Vertex>();
        if (connectorType.getName().equals(this.getType().getStartConnectorType())) {
            elements.add(this.getDb().getVertex(this.getRelationship().getStartNode()));
            return elements;
        }
        if (connectorType.getName().equals(this.getType().getEndConnectorType().getName())) {
            elements.add(this.getDb().getVertex(this.getRelationship().getEndNode()));
            return elements;
        }
        return elements;
    }

    @Override
    public <U extends LeftRestrictedConnectionMode> Vertex getVertex(ConnectorType<U> connectorType) {
        if (connectorType.getName().equals(this.getType().getStartConnectorType().getName())) {
            return this.getDb().getVertex(this.getRelationship().getStartNode());
        }
        if (connectorType.getName().equals(this.getType().getEndConnectorType().getName())) {
            return this.getDb().getVertex(this.getRelationship().getEndNode());
        }
        return null;
    }

    @Override
    public Vertex getEndVertex() {
        return this.getDb().getVertex(this.getRelationship().getEndNode());
    }

    @Override
    public Vertex getStartVertex() {
        return this.getDb().getVertex(this.getRelationship().getStartNode());
    }

    @Override
    public Iterable<Connector<?>> getConnectors(ConnectorType<?> ... connectorTypes) {
        boolean includeStart = false;
        boolean includeEnd = false;
        for (ConnectorType<?> connectorType : connectorTypes) {
            if (connectorType.getName().equals(this.getType().getStartConnectorType().getName())) {
                includeStart = true;
                continue;
            }
            if (!connectorType.getName().equals(this.getType().getEndConnectorType().getName())) continue;
            includeEnd = true;
        }
        ArrayList connectors = new ArrayList();
        if (includeStart) {
            connectors.add(Connector.getInstance(this.getType().getStartConnectorType(), this));
        }
        if (includeEnd) {
            connectors.add(Connector.getInstance(this.getType().getEndConnectorType(), this));
        }
        return connectors;
    }

    @Override
    public Vertex getOtherVertex(Vertex vertex) {
        return this.getDb().getVertex(this.getRelationship().getOtherNode(vertex.getNode()));
    }
}

