/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb;

import org.neo4j.collections.graphdb.BijectiveConnectionMode;
import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.Connection;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.Property;
import org.neo4j.collections.graphdb.PropertyType;
import org.neo4j.collections.graphdb.RightRestrictedConnectionMode;
import org.neo4j.collections.graphdb.SortableBinaryEdge;
import org.neo4j.collections.graphdb.SortableBinaryEdgeType;
import org.neo4j.collections.graphdb.Traversal;
import org.neo4j.collections.graphdb.TraversalDescription;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;

public interface Vertex
extends Traversal {
    public Vertex addEdge(Vertex var1, RelationshipType var2);

    public Vertex addEdge(Vertex var1, SortableBinaryEdgeType<?> var2);

    public Vertex addType(VertexType var1);

    public BinaryEdge createEdgeTo(Vertex var1, RelationshipType var2);

    public <T> SortableBinaryEdge<T> createEdgeTo(Vertex var1, SortableBinaryEdgeType<T> var2);

    public Iterable<BinaryEdge> getBinaryEdges();

    public Iterable<BinaryEdge> getBinaryEdges(Direction var1);

    public Iterable<BinaryEdge> getBinaryEdges(Direction var1, RelationshipType ... var2);

    public Iterable<BinaryEdge> getBinaryEdges(RelationshipType ... var1);

    public Iterable<BinaryEdge> getBinaryEdges(RelationshipType var1, Direction var2);

    public DatabaseService getDb();

    public Iterable<Edge> getEdges(EdgeType ... var1);

    public Iterable<Edge> getEdges(EdgeType var1, ConnectorType<?> ... var2);

    public Edge getEdge(EdgeType var1, ConnectorType<RightRestrictedConnectionMode> var2);

    public Node getNode();

    public <T> Property<T> getProperty(PropertyType<T> var1);

    public PropertyContainer getPropertyContainer();

    public Iterable<PropertyType<?>> getPropertyTypes();

    public <T> T getPropertyValue(PropertyType<T> var1);

    public BinaryEdge getSingleBinaryEdge(RelationshipType var1, Direction var2);

    public Iterable<VertexType> getTypes();

    public boolean hasBinaryEdge();

    public boolean hasBinaryEdge(Direction var1);

    public boolean hasBinaryEdge(Direction var1, RelationshipType ... var2);

    public boolean hasBinaryEdge(RelationshipType ... var1);

    public boolean hasBinaryEdge(RelationshipType var1, Direction var2);

    public boolean hasEdge(EdgeType var1, ConnectorType<?> ... var2);

    public <T> boolean hasProperty(PropertyType<T> var1);

    public Vertex removeProperty(PropertyType<?> var1);

    public Vertex removeType(VertexType var1);

    public <T> Vertex setProperty(PropertyType<T> var1, T var2);

    public Connection<BijectiveConnectionMode> getSelfConnection();

    public Traversal traverse(TraversalDescription var1);
}

