/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb;

import java.util.Iterator;
import org.neo4j.collections.graphdb.Connection;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.Edge;
import org.neo4j.collections.graphdb.Vertex;

public class Connector<T extends ConnectionMode> {
    Connector<T> outer = this;
    private final ConnectorType<T> connectorType;
    private final Edge edge;

    public static Connector<?> getInstance(ConnectorType<?> connectorType, Edge edge) {
        if (connectorType.getConnectionMode().getName().equals(ConnectionMode.UNRESTRICTED.getName())) {
            return new Connector(connectorType, edge);
        }
        if (connectorType.getConnectionMode().getName().equals(ConnectionMode.INJECTIVE.getName())) {
            return new Connector(connectorType, edge);
        }
        if (connectorType.getConnectionMode().getName().equals(ConnectionMode.SURJECTIVE.getName())) {
            return new Connector(connectorType, edge);
        }
        if (connectorType.getConnectionMode().getName().equals(ConnectionMode.BIJECTIVE.getName())) {
            return new Connector(connectorType, edge);
        }
        throw new RuntimeException("Unsupported ConnectionMode " + connectorType.getConnectionMode().getName() + "found");
    }

    public Connector(ConnectorType<T> connectorType, Edge edge) {
        this.connectorType = connectorType;
        this.edge = edge;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public ConnectorType<T> getConnectorType() {
        return this.connectorType;
    }

    public String getName() {
        return this.connectorType.getName();
    }

    public Iterable<Vertex> getVertices() {
        return this.edge.getVertices(this.connectorType);
    }

    public Iterable<Connection<T>> getConnections() {
        return new Iterable<Connection<T>>(){

            @Override
            public Iterator<Connection<T>> iterator() {
                return new Iterator<Connection<T>>(){
                    Iterator<Vertex> vertices;
                    {
                        this.vertices = Connector.this.getVertices().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.vertices.hasNext();
                    }

                    @Override
                    public Connection<T> next() {
                        return new Connection(Connector.this.outer, this.vertices.next());
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }
}

