/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.btree;

import org.neo4j.collections.btree.AbstractBTree;
import org.neo4j.collections.btree.TreeNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class KeyEntry {
    static final String KEY = "key";
    static final String VALUE = "val";
    static final String KEY_VALUE = "key_val";
    private Relationship entryRelationship;
    private TreeNode treeNode;

    KeyEntry(TreeNode treeNode, Relationship underlyingRelationship) {
        assert (treeNode != null);
        assert (underlyingRelationship != null);
        this.treeNode = treeNode;
        this.entryRelationship = underlyingRelationship;
    }

    Relationship getUnderlyingRelationship() {
        return this.entryRelationship;
    }

    TreeNode getTreeNode() {
        return this.treeNode;
    }

    private AbstractBTree getBTree() {
        return this.treeNode.getBTree();
    }

    TreeNode getBeforeSubTree() {
        Relationship subTreeRel = this.getStartNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    TreeNode getAfterSubTree() {
        Relationship subTreeRel = this.getEndNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    KeyEntry getNextKey() {
        Relationship nextKeyRel = this.getEndNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextKeyRel != null) {
            return new KeyEntry(this.getTreeNode(), nextKeyRel);
        }
        return null;
    }

    KeyEntry getPreviousKey() {
        Relationship prevKeyRel = this.getStartNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevKeyRel != null) {
            return new KeyEntry(this.getTreeNode(), prevKeyRel);
        }
        return null;
    }

    public long getKey() {
        return (Long)this.entryRelationship.getProperty(KEY);
    }

    void setKey(long key) {
        this.entryRelationship.setProperty(KEY, (Object)key);
    }

    public Object getValue() {
        return this.entryRelationship.getProperty(VALUE);
    }

    public void setValue(Object value) {
        this.entryRelationship.setProperty(VALUE, value);
    }

    public void setKeyValue(Object keyValue) {
        this.entryRelationship.setProperty(KEY_VALUE, keyValue);
    }

    public Object getKeyValue() {
        return this.entryRelationship.getProperty(KEY_VALUE, null);
    }

    public void remove() {
        this.treeNode.removeEntry(this.getKey());
    }

    public String toString() {
        return "Entry[" + this.getKey() + "," + this.getValue() + "]";
    }

    boolean isLeaf() {
        if (this.getUnderlyingRelationship().getStartNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null) {
            assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null);
            return false;
        }
        assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING) == null);
        return true;
    }

    Node getStartNode() {
        return this.entryRelationship.getStartNode();
    }

    Node getEndNode() {
        return this.entryRelationship.getEndNode();
    }

    void move(TreeNode node, Node startNode, Node endNode) {
        assert (node != null);
        this.treeNode = node;
        long key = this.getKey();
        Object value = this.getValue();
        Object keyValue = this.getKeyValue();
        this.entryRelationship.delete();
        this.entryRelationship = startNode.createRelationshipTo(endNode, (RelationshipType)AbstractBTree.RelTypes.KEY_ENTRY);
        this.setKey(key);
        this.setValue(value);
        if (keyValue != null) {
            this.setKeyValue(keyValue);
        }
    }
}

