/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.btree;

import java.util.Iterator;
import org.neo4j.collections.btree.AbstractBTree;
import org.neo4j.collections.btree.KeyEntry;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;

public class BTree
extends AbstractBTree {
    public BTree(GraphDatabaseService graphDb, Node rootNode) {
        super(graphDb, rootNode);
    }

    public KeyEntry addEntry(long key, Object value) {
        return this.getTreeRoot().addEntry(key, value);
    }

    public KeyEntry addIfAbsent(long key, Object value) {
        return this.getTreeRoot().addEntry(key, value, true);
    }

    public Object getEntry(long key) {
        KeyEntry entry = this.getTreeRoot().getEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Object getClosestLowerEntry(long key) {
        KeyEntry entry = this.getTreeRoot().getClosestLowerEntry(null, key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Object getClosestHigherEntry(long key) {
        KeyEntry entry = this.getTreeRoot().getClosestHigherEntry(null, key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Object removeEntry(long key) {
        return this.getTreeRoot().removeEntry(key);
    }

    @Override
    int getOrder() {
        return 9;
    }

    public Iterable<Object> values() {
        Traverser trav = this.getTreeRoot().getUnderlyingNode().traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition pos) {
                Relationship last = pos.lastRelationshipTraversed();
                return last != null && last.getType().equals((Object)AbstractBTree.RelTypes.KEY_ENTRY);
            }
        }, (RelationshipType)AbstractBTree.RelTypes.KEY_ENTRY, Direction.OUTGOING, (RelationshipType)AbstractBTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        return new ValueTraverser(trav);
    }

    private static class ValueTraverser
    implements Iterable<Object>,
    Iterator<Object> {
        private Iterator<Node> itr;

        ValueTraverser(Traverser trav) {
            this.itr = trav.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Object next() {
            Node node = this.itr.next();
            return node.getSingleRelationship((RelationshipType)AbstractBTree.RelTypes.KEY_ENTRY, Direction.INCOMING).getProperty("val");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Object> iterator() {
            return this;
        }
    }
}

