/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;

@PublicApi
public abstract class GqlException
extends Exception
implements ErrorGqlStatusObject {
    private final ErrorGqlStatusObject innerGqlStatusObject;
    private final String oldMessage;

    protected GqlException(String message, Throwable cause) {
        super(message, cause);
        this.innerGqlStatusObject = null;
        this.oldMessage = message;
    }

    protected GqlException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, message), cause);
        this.innerGqlStatusObject = gqlStatusObject;
        this.oldMessage = message;
    }

    protected GqlException(String message) {
        this(message, null);
    }

    protected GqlException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, null);
    }

    @Override
    public String legacyMessage() {
        return this.oldMessage;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this.innerGqlStatusObject;
    }
}

