/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gqlstatus.CommonGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfo;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class ErrorGqlStatusObjectImplementation
extends CommonGqlStatusObjectImplementation
implements ErrorGqlStatusObject {
    private boolean isCause = false;
    private ErrorGqlStatusObject cause;
    private final Map<GqlParams.GqlParam, Object> paramMap;
    private final GqlStatusInfoCodes gqlStatusInfoCode;

    private ErrorGqlStatusObjectImplementation(GqlStatusInfoCodes gqlStatusInfoCode, Map<GqlParams.GqlParam, Object> parameters, ErrorGqlStatusObject cause, DiagnosticRecord diagnosticRecord) {
        super((GqlStatusInfo)gqlStatusInfoCode, diagnosticRecord, parameters);
        this.gqlStatusInfoCode = gqlStatusInfoCode;
        this.cause = cause;
        this.paramMap = this.replaceNulls(parameters);
    }

    private Map<GqlParams.GqlParam, Object> replaceNulls(Map<GqlParams.GqlParam, Object> parameters) {
        return parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? "null" : e.getValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ErrorGqlStatusObjectImplementation)) return false;
        ErrorGqlStatusObjectImplementation gql = (ErrorGqlStatusObjectImplementation)obj;
        if (!Objects.equals(this.gqlStatusInfoCode, gql.gqlStatusInfoCode)) return false;
        if (!Objects.equals(this.diagnosticRecord, gql.diagnosticRecord)) return false;
        if (!Objects.equals(this.cause, gql.cause)) return false;
        if (!Objects.equals(this.paramMap, gql.paramMap)) return false;
        return true;
    }

    public static Builder from(GqlStatusInfoCodes gqlStatusInfo) {
        return new Builder(gqlStatusInfo);
    }

    @Override
    public Optional<ErrorGqlStatusObject> cause() {
        return Optional.ofNullable(this.cause);
    }

    public boolean isCause() {
        return this.isCause;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this;
    }

    public void setCause(ErrorGqlStatusObject cause) {
        this.cause = cause;
        ErrorGqlStatusObjectImplementation.removeLoops(cause);
        ErrorGqlStatusObjectImplementation.propagatePositions(this.diagnosticRecord, cause);
    }

    private void removeCause() {
        this.cause = null;
    }

    public ErrorGqlStatusObject insertCause(ErrorGqlStatusObjectImplementation newCause) {
        if (this.cause == null) {
            this.setCause(newCause);
        } else {
            ErrorGqlStatusObject errorGqlStatusObject = this.cause;
            if (errorGqlStatusObject instanceof ErrorGqlStatusObjectImplementation) {
                ErrorGqlStatusObjectImplementation implCause = (ErrorGqlStatusObjectImplementation)errorGqlStatusObject;
                this.setCause(implCause.insertCause(newCause));
            } else {
                newCause.setCause(this.cause);
                this.setCause(newCause);
            }
        }
        return this;
    }

    public void markAsCause() {
        this.isCause = true;
    }

    @Override
    public void adjustPosition(int oldOffset, int oldLine, int oldColumn, int newOffset, int newLine, int newCol) {
        super.adjustPosition(oldOffset, oldLine, oldColumn, newOffset, newLine, newCol);
        this.cause().ifPresent(gqlStatusObjectCause -> {
            if (gqlStatusObjectCause instanceof ErrorGqlStatusObjectImplementation) {
                ErrorGqlStatusObjectImplementation errorGqlStatusObjectImplementation = (ErrorGqlStatusObjectImplementation)gqlStatusObjectCause;
                errorGqlStatusObjectImplementation.adjustPosition(oldOffset, oldLine, oldColumn, newOffset, newLine, newCol);
            }
        });
    }

    @Override
    public String getMessage() {
        String gqlMessagePart = this.gqlStatusInfoCode.getMessage(this.paramMap);
        if (!gqlMessagePart.isEmpty()) {
            return String.format("%s: %s", this.gqlStatus(), gqlMessagePart);
        }
        return this.gqlStatus();
    }

    @Override
    public String legacyMessage() {
        return "";
    }

    public String toString() {
        return this.recToString();
    }

    private String recToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Status: ");
        sb.append(this.gqlStatusInfoCode.getStatusString().trim());
        sb.append("\n");
        sb.append("Message: ");
        sb.append(this.insertMessageParameters(this.paramMap).trim());
        sb.append("\n");
        sb.append("Subcondition: ");
        sb.append(this.gqlStatusInfoCode.getSubCondition().trim());
        this.diagnosticRecord.getPosition().ifPresent(s -> {
            sb.append("\n");
            sb.append("Position: ");
            sb.append((String)s);
        });
        if (this.cause != null) {
            sb.append("\n");
            sb.append("Caused by:");
            return sb.append(ErrorGqlStatusObjectImplementation.indent(4, this.cause.toString())).toString();
        }
        return sb.toString();
    }

    public static String indent(int n, String input) {
        String indent = " ".repeat(n);
        String[] lines = input.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(indent).append(line).append("\n");
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static void removeLoops(ErrorGqlStatusObject cause) {
        ErrorGqlStatusObject currentCause = cause;
        ArrayList<ErrorGqlStatusObject> list = new ArrayList<ErrorGqlStatusObject>();
        while (currentCause != null) {
            if (list.contains(currentCause)) {
                ((ErrorGqlStatusObjectImplementation)list.getLast()).removeCause();
                break;
            }
            list.add(currentCause);
            currentCause = currentCause.cause().orElse(null);
        }
    }

    private static void propagatePositions(DiagnosticRecord currentDiagnosticRecord, ErrorGqlStatusObject currentCause) {
        if (currentCause instanceof ErrorGqlStatusObjectImplementation) {
            ErrorGqlStatusObjectImplementation c = (ErrorGqlStatusObjectImplementation)currentCause;
            if (!currentDiagnosticRecord.hasPosition() && c.diagnosticRecord.hasPosition()) {
                Map<String, Integer> position = c.diagnosticRecord.getPositionMap();
                currentDiagnosticRecord.updatePosition(position.getOrDefault("offset", -1), position.getOrDefault("line", -1), position.getOrDefault("column", -1));
            } else if (currentDiagnosticRecord.hasPosition() && !c.diagnosticRecord.hasPosition()) {
                Map<String, Integer> position = currentDiagnosticRecord.getPositionMap();
                c.diagnosticRecord.updatePosition(position.getOrDefault("offset", -1), position.getOrDefault("line", -1), position.getOrDefault("column", -1));
            }
            ErrorGqlStatusObjectImplementation.propagatePositions(c.diagnosticRecord, c.cause);
        }
    }

    public static class Builder {
        private ErrorGqlStatusObject cause = null;
        private final Map<GqlParams.GqlParam, Object> paramMap = new HashMap<GqlParams.GqlParam, Object>();
        private final GqlStatusInfoCodes gqlStatusInfoCode;
        private final DiagnosticRecord.Builder diagnosticRecordBuilder = DiagnosticRecord.from();

        private Builder(GqlStatusInfoCodes gqlStatusInfo) {
            this.gqlStatusInfoCode = gqlStatusInfo;
        }

        public Builder withParam(GqlParams.StringParam param, String value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withParam(GqlParams.BooleanParam param, boolean value) {
            this.paramMap.put(param, value);
            return this;
        }

        public Builder withParam(GqlParams.NumberParam param, Number value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withParam(GqlParams.ListParam param, List<?> value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withCause(ErrorGqlStatusObject cause) {
            if (cause instanceof ErrorGqlStatusObjectImplementation) {
                ErrorGqlStatusObjectImplementation c = (ErrorGqlStatusObjectImplementation)cause;
                c.markAsCause();
            }
            this.cause = cause;
            return this;
        }

        public Builder atPosition(int offset, int line, int col) {
            assert (line < 1 || line == 1 && col == offset + 1 || line > 1 && offset >= col);
            this.diagnosticRecordBuilder.atPosition(offset, line, col);
            return this;
        }

        public ErrorGqlStatusObject build() {
            this.diagnosticRecordBuilder.withClassification(this.gqlStatusInfoCode.getClassification());
            DiagnosticRecord diagnosticRecord = this.diagnosticRecordBuilder.build();
            ErrorGqlStatusObjectImplementation.removeLoops(this.cause);
            ErrorGqlStatusObjectImplementation.propagatePositions(diagnosticRecord, this.cause);
            return new ErrorGqlStatusObjectImplementation(this.gqlStatusInfoCode, this.paramMap, this.cause, diagnosticRecord);
        }

        public ErrorGqlStatusObjectImplementation buildImpl() {
            return (ErrorGqlStatusObjectImplementation)this.build();
        }
    }
}

