/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public enum PrivilegeGqlCodeEntity {
    ROLE("Role"),
    USER("User"),
    DATABASE("Database"),
    DATABASE_ALIAS("Database alias");

    public final String description;

    private PrivilegeGqlCodeEntity(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static ErrorGqlStatusObject entityNotFound(PrivilegeGqlCodeEntity entity, String name) {
        return switch (entity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.userNotFound(name));
            case 0 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.roleNotFound(name));
            case 2, 3 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.databaseNotFound(name));
        };
    }

    public static ErrorGqlStatusObject entityAlreadyExists(PrivilegeGqlCodeEntity entity, String name) {
        return switch (entity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.userAlreadyExists(name));
            case 0 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.roleAlreadyExists(name));
            case 2, 3 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.databaseAlreadyExists(name));
        };
    }

    private static ErrorGqlStatusObject invalidReference(ErrorGqlStatusObject cause) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42001).withCause(cause).build();
    }

    private static ErrorGqlStatusObject userNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N09).withParam(GqlParams.StringParam.user, name).build();
    }

    private static ErrorGqlStatusObject roleNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N10).withParam(GqlParams.StringParam.role, name).build();
    }

    private static ErrorGqlStatusObject databaseNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N00).withParam(GqlParams.StringParam.db, name).build();
    }

    private static ErrorGqlStatusObject userAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N12).withParam(GqlParams.StringParam.user, name).build();
    }

    private static ErrorGqlStatusObject roleAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N13).withParam(GqlParams.StringParam.role, name).build();
    }

    private static ErrorGqlStatusObject databaseAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N11).withParam(GqlParams.StringParam.db, name).build();
    }
}

