/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.NullIndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltextDatabaseIndex;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.token.api.TokenHolder;

public class FulltextIndexBuilder
extends AbstractLuceneIndexBuilder<FulltextIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final TokenHolder propertyKeyTokenHolder;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private boolean populating;
    private IndexUpdateSink indexUpdateSink = NullIndexUpdateSink.INSTANCE;
    private final Config config;

    private FulltextIndexBuilder(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames) {
        super(readOnlyChecker);
        this.config = config;
        this.descriptor = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    public static FulltextIndexBuilder create(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames) {
        return new FulltextIndexBuilder(descriptor, config, readOnlyChecker, propertyKeyTokenHolder, analyzer, propertyNames);
    }

    FulltextIndexBuilder withPopulatingMode(boolean isPopulating) {
        this.populating = isPopulating;
        return this;
    }

    FulltextIndexBuilder withIndexUpdateSink(IndexUpdateSink indexUpdateSink) {
        this.indexUpdateSink = indexUpdateSink;
        return this;
    }

    public DatabaseIndex<FulltextIndexReader> build() {
        Supplier<IndexWriterConfig> writerConfigFactory = this.populating ? () -> IndexWriterConfigs.population((Config)this.config, (Analyzer)this.analyzer) : () -> IndexWriterConfigs.standard((Config)this.config, (Analyzer)this.analyzer);
        WritableIndexPartitionFactory partitionFactory = new WritableIndexPartitionFactory(writerConfigFactory);
        FulltextIndex fulltextIndex = new FulltextIndex(this.storageBuilder.build(), (IndexPartitionFactory)partitionFactory, this.descriptor, this.propertyKeyTokenHolder, this.config, this.analyzer, this.propertyNames);
        return new WritableFulltextDatabaseIndex(this.indexUpdateSink, fulltextIndex, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

