/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.token.api.TokenHolder;

public class FulltextIndex
extends AbstractLuceneIndex<FulltextIndexReader>
implements Closeable {
    private final Config config;
    private final Analyzer analyzer;
    private final TokenHolder propertyKeyTokenHolder;
    private final String[] propertyNames;
    private final Path transactionsFolder;
    private final IndexDescriptor descriptor;

    FulltextIndex(PartitionedIndexStorage storage, IndexPartitionFactory partitionFactory, IndexDescriptor descriptor, TokenHolder propertyKeyTokenHolder, Config config, Analyzer analyzer, String[] propertyNames) {
        super(storage, partitionFactory, descriptor, config);
        this.descriptor = descriptor;
        this.config = config;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        Path indexFolder = storage.getIndexFolder();
        this.transactionsFolder = indexFolder.resolve(indexFolder.getFileName() + ".tx");
    }

    public void open() throws IOException {
        super.open();
        this.indexStorage.prepareFolder(this.transactionsFolder);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.indexStorage.cleanupFolder(this.transactionsFolder);
    }

    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected FulltextIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        return this.createPartitionedReader(partitions);
    }

    protected FulltextIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List searchers = FulltextIndex.acquireSearchers(partitions);
        return new FulltextIndexReader(searchers, this.propertyKeyTokenHolder, this.getDescriptor(), this.config, this.analyzer, this.propertyNames);
    }
}

