/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class FulltextIndexCapability
implements IndexCapability {
    private static final IndexBehaviour[] EVENTUALLY_CONSISTENT_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.EVENTUALLY_CONSISTENT, IndexBehaviour.SKIP_AND_LIMIT};
    private static final IndexBehaviour[] NORMAL_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.SKIP_AND_LIMIT};
    private final boolean isEventuallyConsistent;

    public FulltextIndexCapability(boolean isEventuallyConsistent) {
        this.isEventuallyConsistent = isEventuallyConsistent;
    }

    public boolean supportsOrdering() {
        return false;
    }

    public boolean supportsReturningValues() {
        return false;
    }

    public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
        Preconditions.requireNonEmpty((Object[])valueCategories);
        Preconditions.requireNoNullElements((Object[])valueCategories);
        boolean anyValidCategory = false;
        block3: for (ValueCategory valueCategory : valueCategories) {
            switch (valueCategory) {
                case TEXT: 
                case TEXT_ARRAY: {
                    anyValidCategory = true;
                    continue block3;
                }
            }
        }
        return anyValidCategory;
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
        if (queryType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
            return true;
        }
        return queryType == IndexQuery.IndexQueryType.FULLTEXT_SEARCH && valueCategory == ValueCategory.TEXT;
    }

    public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
        return 1.0;
    }

    public boolean supportPartitionedScan(IndexQuery ... queries) {
        Preconditions.requireNonEmpty((Object[])queries);
        Preconditions.requireNoNullElements((Object[])queries);
        return false;
    }

    public IndexBehaviour[] behaviours() {
        return this.isEventuallyConsistent ? EVENTUALLY_CONSISTENT_BEHAVIOUR : NORMAL_BEHAVIOUR;
    }
}

