/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAnalyzerLoader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProgressor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionState;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.PreparedSearch;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.fulltext.StatsCollector;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.partition.Neo4jIndexSearcher;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class FulltextIndexReader
implements ValueIndexReader {
    static final LongPredicate ALWAYS_FALSE = value -> false;
    private final List<SearcherReference> searchers;
    private final TokenHolder propertyKeyTokenHolder;
    private final IndexDescriptor index;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private final FulltextIndexTransactionState transactionState;

    FulltextIndexReader(List<SearcherReference> searchers, TokenHolder propertyKeyTokenHolder, IndexDescriptor descriptor, Config config, Analyzer analyzer, String[] propertyNames) {
        this.searchers = searchers;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.index = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.transactionState = new FulltextIndexTransactionState(descriptor, config, analyzer, propertyNames);
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... queries) throws IndexNotApplicableKernelException {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (PropertyIndexQuery indexQuery : queries) {
            if (indexQuery.type() == IndexQuery.IndexQueryType.FULLTEXT_SEARCH) {
                PropertyIndexQuery.FulltextSearchPredicate fulltextSearch = (PropertyIndexQuery.FulltextSearchPredicate)indexQuery;
                try {
                    queryBuilder.add(this.parseFulltextQuery(fulltextSearch.query(), fulltextSearch.queryAnalyzer()), BooleanClause.Occur.SHOULD);
                    continue;
                }
                catch (ParseException e) {
                    throw new RuntimeException("Could not parse the given fulltext search query: '" + fulltextSearch.query() + "'.", e);
                }
            }
            throw new IndexNotApplicableKernelException("A fulltext schema index cannot answer " + indexQuery.type() + " queries on " + indexQuery.valueCategory() + " values.");
        }
        BooleanQuery query = queryBuilder.build();
        ValuesIterator itr = this.searchLucene((Query)query, constraints, context, context.cursorContext(), context.memoryTracker());
        FulltextIndexProgressor progressor = new FulltextIndexProgressor(itr, client, constraints);
        client.initialize(this.index, (IndexProgressor)progressor, accessMode, true, false, constraints, queries);
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        long count = 0L;
        for (SearcherReference searcher : this.searchers) {
            try {
                String[] propertyKeys = new String[propertyKeyIds.length];
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    propertyKeys[i] = this.getPropertyKeyName(propertyKeyIds[i]);
                }
                Query query = LuceneFulltextDocumentStructure.newCountEntityEntriesQuery(entityId, propertyKeys, propertyValues);
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.getIndexSearcher().search(query, (Collector)collector);
                count += (long)collector.getTotalHits();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public void close() {
        ArrayList<Object> resources = new ArrayList<Object>(this.searchers.size() + 1);
        resources.addAll(this.searchers);
        resources.add(this.transactionState);
        IOUtils.close(IndexReaderCloseException::new, resources);
    }

    private Query parseFulltextQuery(String query, String queryAnalyzer) throws ParseException {
        Analyzer actualQueryAnalyzer = queryAnalyzer != null ? FulltextIndexAnalyzerLoader.INSTANCE.createAnalyzerFromString(queryAnalyzer) : this.analyzer;
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(this.propertyNames, actualQueryAnalyzer);
        multiFieldQueryParser.setAllowLeadingWildcard(true);
        return multiFieldQueryParser.parse(query);
    }

    private ValuesIterator searchLucene(Query query, IndexQueryConstraints constraints, QueryContext context, CursorContext cursorContext, MemoryTracker memoryTracker) {
        try {
            query = this.searchers.get(0).getIndexSearcher().rewrite(query);
            boolean includeTransactionState = context.getTransactionStateOrNull() != null && !FulltextIndexSettings.isEventuallyConsistent(this.index);
            LongPredicate filter = includeTransactionState ? this.transactionState.isModifiedInTransactionPredicate() : ALWAYS_FALSE;
            ArrayList<PreparedSearch> searches = new ArrayList<PreparedSearch>(this.searchers.size() + 1);
            for (SearcherReference searcher : this.searchers) {
                Neo4jIndexSearcher indexSearcher = searcher.getIndexSearcher();
                searches.add(new PreparedSearch(indexSearcher, filter));
            }
            if (includeTransactionState) {
                SearcherReference reference = this.transactionState.maybeUpdate(context, cursorContext, memoryTracker);
                searches.add(new PreparedSearch(reference.getIndexSearcher(), ALWAYS_FALSE));
            }
            StatsCollector statsCollector = new StatsCollector(searches);
            ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>(searches.size());
            for (PreparedSearch search : searches) {
                results.add(search.search(query, constraints, statsCollector));
            }
            return ScoreEntityIterator.mergeIterators(results);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyKeyName(int propertyKey) throws TokenNotFoundException {
        return this.propertyKeyTokenHolder.getTokenById(propertyKey).name();
    }
}

