/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;
import org.neo4j.kernel.api.impl.fulltext.PreparedSearch;
import org.neo4j.kernel.api.impl.index.partition.Neo4jIndexSearcher;

class StatsCollector {
    private final List<PreparedSearch> searches;
    private final Map<Term, Optional<TermStatistics>> termStatisticsCache;
    private final Map<String, Optional<CollectionStatistics>> collStatisticsCache;

    StatsCollector(List<PreparedSearch> searches) {
        this.searches = searches;
        this.termStatisticsCache = new HashMap<Term, Optional<TermStatistics>>();
        this.collStatisticsCache = new HashMap<String, Optional<CollectionStatistics>>();
    }

    TermStatistics termStatistics(Term term) {
        return this.termStatisticsCache.computeIfAbsent(term, this::computeTermStatistics).orElse(null);
    }

    private Optional<TermStatistics> computeTermStatistics(Term term) {
        ArrayList<TermStatistics> statistics = new ArrayList<TermStatistics>(this.searches.size());
        for (PreparedSearch search : this.searches) {
            Neo4jIndexSearcher searcher = search.searcher();
            try {
                TermStates context = TermStates.build((IndexReaderContext)searcher.getTopReaderContext(), (Term)term, (boolean)true);
                if (context.docFreq() <= 0) continue;
                TermStatistics statistic = searcher.termStatistics(term, context.docFreq(), context.totalTermFreq());
                statistics.add(statistic);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        long docFreq = 0L;
        long totalTermFreq = 0L;
        for (TermStatistics statistic : statistics) {
            docFreq += statistic.docFreq();
            totalTermFreq += statistic.totalTermFreq();
        }
        if (docFreq == 0L) {
            return Optional.empty();
        }
        BytesRef bytesTerm = ((TermStatistics)statistics.get(0)).term();
        TermStatistics result = new TermStatistics(bytesTerm, docFreq, totalTermFreq);
        return Optional.of(result);
    }

    CollectionStatistics collectionStatistics(String field) {
        return this.collStatisticsCache.computeIfAbsent(field, this::computeCollStatistics).orElse(null);
    }

    private Optional<CollectionStatistics> computeCollStatistics(String field) {
        ArrayList<CollectionStatistics> statistics = new ArrayList<CollectionStatistics>(this.searches.size());
        for (PreparedSearch search : this.searches) {
            try {
                CollectionStatistics statistic = search.searcher().collectionStatistics(field);
                if (statistic == null) continue;
                statistics.add(statistic);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        long maxDoc = 0L;
        long docCount = 0L;
        long sumTotalTermFreq = 0L;
        long sumDocFreq = 0L;
        for (CollectionStatistics statistic : statistics) {
            maxDoc += statistic.maxDoc();
            docCount += statistic.docCount();
            sumTotalTermFreq += statistic.sumTotalTermFreq();
            sumDocFreq += statistic.sumDocFreq();
        }
        if (docCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq));
    }
}

