/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionStateVisitor;
import org.neo4j.kernel.api.impl.fulltext.TransactionStateLuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class FulltextIndexTransactionState
implements Closeable {
    private final List<AutoCloseable> toCloseLater = new ArrayList<AutoCloseable>();
    private final MutableLongSet modifiedEntityIdsInThisTransaction;
    private final TransactionStateLuceneIndexWriter writer;
    private final FulltextIndexTransactionStateVisitor txStateVisitor;
    private final boolean visitingNodes;
    private long lastUpdateRevision;
    private SearcherReference currentSearcher;

    FulltextIndexTransactionState(IndexDescriptor descriptor, Analyzer analyzer, String[] propertyNames) {
        this.writer = new TransactionStateLuceneIndexWriter(analyzer);
        this.modifiedEntityIdsInThisTransaction = new LongHashSet();
        this.visitingNodes = descriptor.schema().entityType() == EntityType.NODE;
        this.txStateVisitor = new FulltextIndexTransactionStateVisitor(descriptor, propertyNames, this.modifiedEntityIdsInThisTransaction, this.writer);
    }

    SearcherReference maybeUpdate(QueryContext context, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.currentSearcher == null || this.lastUpdateRevision != context.getTransactionStateOrNull().getDataRevision()) {
            try {
                this.updateSearcher(context, cursorTracer, memoryTracker);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not update fulltext schema index transaction state.", e);
            }
        }
        return this.currentSearcher;
    }

    private void updateSearcher(QueryContext context, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws Exception {
        Read read = context.getRead();
        CursorFactory cursors = context.cursors();
        ReadableTransactionState state = context.getTransactionStateOrNull();
        this.modifiedEntityIdsInThisTransaction.clear();
        this.writer.resetWriterState();
        try (NodeCursor nodeCursor = this.visitingNodes ? cursors.allocateFullAccessNodeCursor(cursorTracer) : null;
             RelationshipScanCursor relationshipCursor = this.visitingNodes ? null : cursors.allocateRelationshipScanCursor(cursorTracer);
             PropertyCursor propertyCursor = cursors.allocateFullAccessPropertyCursor(cursorTracer, memoryTracker);){
            state.accept((TxStateVisitor)this.txStateVisitor.init(read, nodeCursor, relationshipCursor, propertyCursor));
        }
        this.currentSearcher = this.writer.getNearRealTimeSearcher();
        this.toCloseLater.add((AutoCloseable)this.currentSearcher);
        this.lastUpdateRevision = state.getDataRevision();
    }

    @Override
    public void close() throws IOException {
        this.toCloseLater.add(this.writer);
        IOUtils.closeAll(this.toCloseLater);
    }

    public LongPredicate isModifiedInTransactionPredicate() {
        return arg_0 -> ((MutableLongSet)this.modifiedEntityIdsInThisTransaction).contains(arg_0);
    }
}

