/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionState;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class FulltextIndexReader
implements IndexReader {
    private final List<SearcherReference> searchers;
    private final TokenHolder propertyKeyTokenHolder;
    private final IndexDescriptor index;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private final FulltextIndexTransactionState transactionState;

    FulltextIndexReader(List<SearcherReference> searchers, TokenHolder propertyKeyTokenHolder, IndexDescriptor descriptor, Analyzer analyzer, String[] propertyNames) {
        this.searchers = searchers;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.index = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.transactionState = new FulltextIndexTransactionState(descriptor, analyzer, propertyNames);
    }

    private Query parseFulltextQuery(String query) throws ParseException {
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(this.propertyNames, this.analyzer);
        multiFieldQueryParser.setAllowLeadingWildcard(true);
        return multiFieldQueryParser.parse(query);
    }

    private ValuesIterator indexQuery(Query query) {
        ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>();
        for (SearcherReference searcher : this.searchers) {
            ValuesIterator iterator = FulltextIndexReader.searchLucene(searcher, query);
            results.add(iterator);
        }
        return ScoreEntityIterator.mergeIterators(results);
    }

    static ValuesIterator searchLucene(SearcherReference searcher, Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector(true);
            searcher.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector.getValuesSortedByRelevance("__neo4j__lucene__fulltext__index__internal__id__");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... queries) throws IndexNotApplicableKernelException {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (IndexQuery indexQuery : queries) {
            if (indexQuery.type() == IndexQuery.IndexQueryType.fulltextSearch) {
                IndexQuery.FulltextSearchPredicate fulltextSearch = (IndexQuery.FulltextSearchPredicate)indexQuery;
                try {
                    queryBuilder.add(this.parseFulltextQuery(fulltextSearch.query()), BooleanClause.Occur.SHOULD);
                    continue;
                }
                catch (ParseException e) {
                    throw new RuntimeException("Could not parse the given fulltext search query: '" + fulltextSearch.query() + "'.", e);
                }
            }
            throw new IndexNotApplicableKernelException("A fulltext schema index cannot answer " + indexQuery.type() + " queries.");
        }
        BooleanQuery query = queryBuilder.build();
        ValuesIterator itr = this.indexQuery((Query)query);
        ReadableTransactionState state = context.getTransactionStateOrNull();
        if (state != null && !FulltextIndexSettings.isEventuallyConsistent(this.index)) {
            this.transactionState.maybeUpdate(context);
            itr = this.transactionState.filter(itr, query);
        }
        FulltextIndexProgressor progressor = new FulltextIndexProgressor(itr, client);
        client.initialize(this.index, (IndexProgressor)progressor, queries, indexOrder, needsValues, true);
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        long count = 0L;
        for (SearcherReference searcher : this.searchers) {
            try {
                String[] propertyKeys = new String[propertyKeyIds.length];
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    propertyKeys[i] = this.getPropertyKeyName(propertyKeyIds[i]);
                }
                Query query = LuceneFulltextDocumentStructure.newCountNodeEntriesQuery(nodeId, propertyKeys, propertyValues);
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.getIndexSearcher().search(query, (Collector)collector);
                count += (long)collector.getTotalHits();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public void distinctValues(IndexProgressor.EntityValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        throw new UnsupportedOperationException("Fulltext indexes does not support distinctValues queries");
    }

    public void close() {
        ArrayList<Object> resources = new ArrayList<Object>(this.searchers.size() + 1);
        resources.addAll(this.searchers);
        resources.add(this.transactionState);
        IOUtils.close(IndexReaderCloseException::new, resources);
    }

    private String getPropertyKeyName(int propertyKey) throws TokenNotFoundException {
        return this.propertyKeyTokenHolder.getTokenById(propertyKey).name();
    }

    private static class FulltextIndexProgressor
    implements IndexProgressor {
        private final ValuesIterator itr;
        private final IndexProgressor.EntityValueClient client;

        private FulltextIndexProgressor(ValuesIterator itr, IndexProgressor.EntityValueClient client) {
            this.itr = itr;
            this.client = client;
        }

        public boolean next() {
            float score;
            long entityId;
            boolean accepted;
            if (!this.itr.hasNext()) {
                return false;
            }
            while (!(accepted = this.client.acceptEntity(entityId = this.itr.next(), score = this.itr.currentScore(), (Value[])null)) && this.itr.hasNext()) {
            }
            return accepted;
        }

        public void close() {
        }
    }
}

