/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class IndexUpdateSink {
    private final JobScheduler scheduler;
    private final Semaphore updateQueueLimit;
    private final int eventuallyConsistentUpdateQueueLimit;
    private final OutOfOrderSequence jobSequence = new ArrayQueueOutOfOrderSequence(-1L, 10, OutOfOrderSequence.EMPTY_META);
    private final AtomicLong nextJobId = new AtomicLong();

    IndexUpdateSink(JobScheduler scheduler, int eventuallyConsistentUpdateQueueLimit) {
        this.scheduler = scheduler;
        this.updateQueueLimit = new Semaphore(eventuallyConsistentUpdateQueueLimit);
        this.eventuallyConsistentUpdateQueueLimit = eventuallyConsistentUpdateQueueLimit;
    }

    public void enqueueTransactionBatchOfUpdates(DatabaseIndex<? extends IndexReader> index, IndexUpdater indexUpdater, Collection<IndexEntryUpdate> updates) {
        int numberOfUpdates = Math.min(updates.size(), this.eventuallyConsistentUpdateQueueLimit);
        try {
            this.updateQueueLimit.acquire(numberOfUpdates);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        long jobId = this.nextJobId.getAndIncrement();
        Runnable eventualUpdate = () -> {
            try (IndexUpdater indexUpdater2 = indexUpdater;){
                for (IndexEntryUpdate update : updates) {
                    indexUpdater.process(update);
                }
            }
            catch (IndexEntryConflictException e) {
                IndexUpdateSink.markAsFailed(index, e);
            }
            finally {
                try {
                    this.updateQueueLimit.release(numberOfUpdates);
                }
                finally {
                    this.jobSequence.offer(jobId, OutOfOrderSequence.EMPTY_META);
                }
            }
        };
        try {
            JobMonitoringParams monitoringParams = JobMonitoringParams.systemJob((String)("Background update of index '" + index.getDescriptor().getName() + "'"));
            this.scheduler.schedule(Group.INDEX_UPDATING, monitoringParams, eventualUpdate);
        }
        catch (Exception e) {
            this.updateQueueLimit.release(numberOfUpdates);
            throw e;
        }
    }

    private static void markAsFailed(DatabaseIndex<? extends IndexReader> index, IndexEntryConflictException conflict) {
        try {
            index.markAsFailed(conflict.getMessage());
        }
        catch (IOException ioe) {
            ioe.addSuppressed(conflict);
            throw new UncheckedIOException(ioe);
        }
    }

    public void awaitUpdateApplication() {
        long targetJobId = this.nextJobId.get() - 1L;
        while (this.jobSequence.getHighestGapFreeNumber() < targetJobId) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }
}

