/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bookmark.LocalBookmark;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricKernelTransaction;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.SingleDbTransaction;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.FabricCompoundTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.virtual.MapValue;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FabricLocalExecutor {
    private final FabricConfig config;
    private final FabricDatabaseManager dbms;
    private final LocalGraphTransactionIdTracker transactionIdTracker;

    public FabricLocalExecutor(FabricConfig config, FabricDatabaseManager dbms, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.config = config;
        this.dbms = dbms;
        this.transactionIdTracker = transactionIdTracker;
    }

    public LocalTransactionContext startTransactionContext(FabricCompoundTransaction parentTransaction, FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager) {
        return new LocalTransactionContext(parentTransaction, transactionInfo, bookmarkManager);
    }

    public class LocalTransactionContext
    implements AutoCloseable {
        private final Map<UUID, KernelTxWrapper> kernelTransactions = new ConcurrentHashMap<UUID, KernelTxWrapper>();
        private final Set<InternalTransaction> internalTransactions = ConcurrentHashMap.newKeySet();
        private final FabricCompoundTransaction parentTransaction;
        private final FabricTransactionInfo transactionInfo;
        private final TransactionBookmarkManager bookmarkManager;

        private LocalTransactionContext(FabricCompoundTransaction parentTransaction, FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager) {
            this.parentTransaction = parentTransaction;
            this.transactionInfo = transactionInfo;
            this.bookmarkManager = bookmarkManager;
        }

        public StatementResult run(Location.Local location, TransactionMode transactionMode, FabricStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, Flux<Record> input, ExecutionOptions executionOptions, Boolean targetsComposite) {
            FabricKernelTransaction kernelTransaction = this.getOrCreateTx(location, transactionMode, targetsComposite);
            return kernelTransaction.run(query, params, input, parentLifecycle, executionOptions);
        }

        @Override
        public void close() {
        }

        public Set<InternalTransaction> getInternalTransactions() {
            return this.internalTransactions;
        }

        public FabricKernelTransaction getOrCreateTx(Location.Local location, TransactionMode transactionMode, Boolean targetsComposite) {
            KernelTxWrapper existingTx = this.kernelTransactions.get(location.getUuid());
            if (!targetsComposite.booleanValue() && existingTx != null) {
                this.maybeUpgradeToWritingTransaction(existingTx, transactionMode);
                return existingTx.fabricKernelTransaction;
            }
            GraphDatabaseAPI databaseFacade = this.getDatabaseFacade(location);
            this.bookmarkManager.getBookmarkForLocal(location).ifPresent(bookmark -> FabricLocalExecutor.this.transactionIdTracker.awaitGraphUpToDate(location, bookmark.transactionId()));
            return this.kernelTransactions.computeIfAbsent((UUID)location.getUuid(), (Function<UUID, KernelTxWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrCreateTx$2(org.neo4j.fabric.executor.Location$Local org.neo4j.fabric.transaction.TransactionMode org.neo4j.kernel.internal.GraphDatabaseAPI java.util.UUID ), (Ljava/util/UUID;)Lorg/neo4j/fabric/executor/FabricLocalExecutor$KernelTxWrapper;)((LocalTransactionContext)this, (Location.Local)location, (TransactionMode)transactionMode, (GraphDatabaseAPI)databaseFacade)).fabricKernelTransaction;
        }

        private void maybeUpgradeToWritingTransaction(KernelTxWrapper tx, TransactionMode transactionMode) {
            if (transactionMode == TransactionMode.DEFINITELY_WRITE) {
                this.parentTransaction.upgradeToWritingTransaction(tx);
            }
        }

        private FabricKernelTransaction beginKernelTx(GraphDatabaseAPI databaseFacade) {
            DependencyResolver dependencyResolver = databaseFacade.getDependencyResolver();
            ExecutionEngine executionEngine = (ExecutionEngine)dependencyResolver.resolveDependency(ExecutionEngine.class);
            InternalTransaction internalTransaction = this.beginInternalTransaction(databaseFacade, this.transactionInfo);
            TransactionalContextFactory transactionalContextFactory = (TransactionalContextFactory)dependencyResolver.resolveDependency(TransactionalContextFactory.class);
            return new FabricKernelTransaction(executionEngine, transactionalContextFactory, internalTransaction, FabricLocalExecutor.this.config, this.transactionInfo);
        }

        private GraphDatabaseAPI getDatabaseFacade(Location.Local location) {
            try {
                GraphDatabaseAPI facade = FabricLocalExecutor.this.dbms.getDatabaseFacade(location.getDatabaseName());
                if (!Objects.equals(facade.databaseId().databaseId().uuid(), location.getUuid())) {
                    throw new FabricException((Status)Status.Transaction.Outdated, "The locations associated with the graph name %s have changed whilst the transaction was running.", location.getDatabaseName());
                }
                return facade;
            }
            catch (UnavailableException e) {
                throw new FabricException((Status)Status.General.DatabaseUnavailable, (Throwable)e);
            }
        }

        private InternalTransaction beginInternalTransaction(GraphDatabaseAPI databaseAPI, FabricTransactionInfo transactionInfo) {
            KernelTransaction.Type kernelTransactionType = this.getKernelTransactionType(transactionInfo);
            InternalTransaction internalTransaction = databaseAPI.beginTransaction(kernelTransactionType, transactionInfo.getLoginContext(), transactionInfo.getClientConnectionInfo(), transactionInfo.getTxTimeout().toMillis(), TimeUnit.MILLISECONDS, this.parentTransaction::childTransactionTerminated, this::transformTerminalOperationError);
            if (transactionInfo.getTxMetadata() != null) {
                internalTransaction.setMetaData(transactionInfo.getTxMetadata());
            }
            this.internalTransactions.add(internalTransaction);
            return internalTransaction;
        }

        private KernelTransaction.Type getKernelTransactionType(FabricTransactionInfo fabricTransactionInfo) {
            if (fabricTransactionInfo.isImplicitTransaction()) {
                return KernelTransaction.Type.IMPLICIT;
            }
            return KernelTransaction.Type.EXPLICIT;
        }

        private RuntimeException transformTerminalOperationError(Exception e) {
            if (e instanceof Status.HasStatus) {
                if (e instanceof RuntimeException) {
                    return (RuntimeException)e;
                }
                return new FabricException(((Status.HasStatus)e).status(), e.getMessage(), e);
            }
            throw new TransactionFailureException("Unable to complete transaction.", (Throwable)e);
        }

        private /* synthetic */ KernelTxWrapper lambda$getOrCreateTx$2(Location.Local location, TransactionMode transactionMode, GraphDatabaseAPI databaseFacade, UUID dbUuid) {
            return this.parentTransaction.registerNewChildTransaction(location, transactionMode, () -> {
                FabricKernelTransaction tx = this.beginKernelTx(databaseFacade);
                return new KernelTxWrapper(tx, this.bookmarkManager, location);
            });
        }
    }

    private class KernelTxWrapper
    implements SingleDbTransaction {
        private final FabricKernelTransaction fabricKernelTransaction;
        private final TransactionBookmarkManager bookmarkManager;
        private final Location.Local location;

        KernelTxWrapper(FabricKernelTransaction fabricKernelTransaction, TransactionBookmarkManager bookmarkManager, Location.Local location) {
            this.fabricKernelTransaction = fabricKernelTransaction;
            this.bookmarkManager = bookmarkManager;
            this.location = location;
        }

        @Override
        public Mono<Void> commit() {
            return Mono.fromRunnable(this::doCommit);
        }

        @Override
        public Mono<Void> rollback() {
            return Mono.fromRunnable(this::doRollback);
        }

        private void doCommit() {
            this.fabricKernelTransaction.commit();
            long transactionId = FabricLocalExecutor.this.transactionIdTracker.getTransactionId(this.location);
            this.bookmarkManager.localTransactionCommitted(this.location, new LocalBookmark(transactionId));
        }

        private void doRollback() {
            this.fabricKernelTransaction.rollback();
        }

        @Override
        public Mono<Void> terminate(Status reason) {
            return Mono.fromRunnable(() -> this.fabricKernelTransaction.terminate(reason));
        }

        @Override
        public Location location() {
            return this.location;
        }
    }
}

