/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.io.Serializable;
import org.neo4j.configuration.helpers.NormalizedGraphName;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.CatalogName$;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Catalog$
implements Serializable {
    public static final Catalog$ MODULE$ = new Catalog$();
    private static final Catalog graphByNameView;

    static {
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"graph", "byName"}))), (Object)new Catalog.ByNameView())}));
        Map<CatalogName, Catalog.Graph> x$2 = MODULE$.apply$default$1();
        graphByNameView = new Catalog(x$2, (Map<CatalogName, Catalog.View>)x$1);
    }

    public Map<CatalogName, Catalog.Graph> $lessinit$greater$default$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<CatalogName, Catalog.View> $lessinit$greater$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public NormalizedGraphName org$neo4j$fabric$eval$Catalog$$toGraphName(NormalizedDatabaseName name) {
        return new NormalizedGraphName(name.name());
    }

    public Catalog create(Seq<Catalog.Alias> graphAliases, Seq<Tuple2<Catalog.Composite, Seq<Catalog.Alias>>> composites) {
        Catalog databasesAndAliases = this.byQualifiedName(graphAliases);
        Catalog compositesAndAliases = (Catalog)composites.foldLeft((Object)this.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Catalog catalog = (Catalog)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Catalog.Composite composite = (Catalog.Composite)tuple22._1();
                    Seq aliases = (Seq)tuple22._2();
                    Catalog.Composite composite2 = composite;
                    Catalog byName = MODULE$.byQualifiedName((Seq<Catalog.Graph>)((Seq)aliases.$plus$colon((Object)composite2)));
                    return catalog.$plus$plus(byName);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return databasesAndAliases.$plus$plus(compositesAndAliases).$plus$plus(this.graphByNameView());
    }

    public Catalog empty() {
        return new Catalog((Map<CatalogName, Catalog.Graph>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), this.apply$default$2());
    }

    public Catalog byQualifiedName(Seq<Catalog.Graph> graphs) {
        return new Catalog((Map<CatalogName, Catalog.Graph>)((IterableOnceOps)graphs.map((Function1 & Serializable)graph -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.catalogName((Catalog.Graph)graph)), graph))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.apply$default$2());
    }

    public CatalogName catalogName(Catalog.Graph graph) {
        Option<NormalizedGraphName> option = graph.namespace();
        if (option instanceof Some) {
            Some some = (Some)option;
            NormalizedGraphName ns = (NormalizedGraphName)some.value();
            return CatalogName$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ns.name(), graph.name().name()}));
        }
        if (None$.MODULE$.equals(option)) {
            return CatalogName$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{graph.name().name()}));
        }
        throw new MatchError(option);
    }

    private Catalog graphByNameView() {
        return graphByNameView;
    }

    public String org$neo4j$fabric$eval$Catalog$$normalize(String graphName) {
        return new NormalizedGraphName(graphName).name();
    }

    public CatalogName org$neo4j$fabric$eval$Catalog$$normalize(CatalogName name) {
        return new CatalogName(name.parts().map((Function1 & Serializable)graphName -> MODULE$.org$neo4j$fabric$eval$Catalog$$normalize((String)graphName)));
    }

    private CatalogName normalizedName(Seq<String> parts) {
        return this.org$neo4j$fabric$eval$Catalog$$normalize(CatalogName$.MODULE$.apply(parts));
    }

    public Catalog apply(Map<CatalogName, Catalog.Graph> graphs, Map<CatalogName, Catalog.View> views) {
        return new Catalog(graphs, views);
    }

    public Map<CatalogName, Catalog.Graph> apply$default$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<CatalogName, Catalog.View> apply$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<Tuple2<Map<CatalogName, Catalog.Graph>, Map<CatalogName, Catalog.View>>> unapply(Catalog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.graphs(), x$0.views()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Catalog$.class);
    }

    private Catalog$() {
    }
}

