/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bootstrap;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bolt.BoltFabricDatabaseManagementService;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bootstrap.FabricReactorHooksService;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.eval.CommunityCatalogManager;
import org.neo4j.fabric.eval.DatabaseLookup;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.ThrowingFabricRemoteExecutor;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricTransactionMonitor;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.SystemNanoClock;

public abstract class FabricServicesBootstrap {
    private final FabricConfig fabricConfig;
    protected final Dependencies dependencies;
    protected final LogService logService;
    private final ServiceBootstrapper serviceBootstrapper;
    private final Config config;
    private final AvailabilityGuard availabilityGuard;
    protected final DatabaseContextProvider<? extends DatabaseContext> databaseProvider;
    protected final AbstractSecurityLog securityLog;
    protected final DatabaseReferenceRepository databaseReferenceRepo;

    public FabricServicesBootstrap(LifeSupport lifeSupport, Dependencies dependencies, LogService logService, AbstractSecurityLog securityLog, DatabaseContextProvider<? extends DatabaseContext> databaseProvider, DatabaseReferenceRepository databaseReferenceRepo, boolean isFallback) {
        this.dependencies = dependencies;
        this.logService = logService;
        this.securityLog = securityLog;
        this.databaseProvider = databaseProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.serviceBootstrapper = new ServiceBootstrapper(lifeSupport, dependencies);
        this.config = (Config)dependencies.resolveDependency(Config.class);
        this.availabilityGuard = (AvailabilityGuard)dependencies.resolveDependency(AvailabilityGuard.class);
        this.fabricConfig = this.bootstrapFabricConfig(isFallback);
    }

    protected <T> T register(T dependency, Class<T> dependencyType) {
        return this.serviceBootstrapper.registerService(dependency, dependencyType);
    }

    protected <T> T resolve(Class<T> type) {
        return (T)this.dependencies.resolveDependency(type);
    }

    public void bootstrapServices(DatabaseManagementService databaseManagementService) {
        InternalLogProvider internalLogProvider = this.logService.getInternalLogProvider();
        DatabaseContextProvider databaseManager = this.resolve(DatabaseContextProvider.class);
        FabricDatabaseManager fabricDatabaseManager = this.register(this.createFabricDatabaseManager(this.fabricConfig), FabricDatabaseManager.class);
        JobScheduler jobScheduler = this.resolve(JobScheduler.class);
        Monitors monitors = this.resolve(Monitors.class);
        Tracers tracers = this.resolve(Tracers.class);
        FabricRemoteExecutor remoteExecutor = this.bootstrapRemoteStack();
        Config serverConfig = (Config)this.dependencies.resolveDependency(Config.class);
        SystemNanoClock systemNanoClock = this.resolve(SystemNanoClock.class);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(databaseManagementService, monitors, systemNanoClock);
        DatabaseIdRepository databaseIdRepository = this.databaseProvider.databaseIdRepository();
        LocalGraphTransactionIdTracker localGraphTransactionIdTracker = this.register(new LocalGraphTransactionIdTracker(transactionIdTracker, databaseIdRepository, serverConfig), LocalGraphTransactionIdTracker.class);
        FabricLocalExecutor localExecutor = this.register(new FabricLocalExecutor(this.fabricConfig, fabricDatabaseManager, localGraphTransactionIdTracker), FabricLocalExecutor.class);
        FabricTransactionMonitor transactionMonitor = this.register(new FabricTransactionMonitor(this.config, systemNanoClock, this.logService, this.fabricConfig), FabricTransactionMonitor.class);
        long transactionCheckInterval = ((Duration)this.config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis();
        this.register(new TransactionMonitorScheduler((TransactionMonitor)transactionMonitor, jobScheduler, transactionCheckInterval, null), TransactionMonitorScheduler.class);
        ErrorReporter errorReporter = new ErrorReporter(this.logService);
        CatalogManager catalogManager = this.register(this.createCatalogManger(fabricDatabaseManager), CatalogManager.class);
        GlobalProcedures globalProcedures = (GlobalProcedures)this.dependencies.resolveDependency(GlobalProcedures.class);
        this.register(new TransactionManager(remoteExecutor, localExecutor, catalogManager, transactionMonitor, this.securityLog, systemNanoClock, this.config, this.availabilityGuard, errorReporter, globalProcedures), TransactionManager.class);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)this.config);
        FabricStatementLifecycles statementLifecycles = new FabricStatementLifecycles((DatabaseContextProvider<? extends DatabaseContext>)databaseManager, monitors, this.config, tracers.getLockTracer(), systemNanoClock);
        MonitoredJobExecutor monitoredExecutor = jobScheduler.monitoredJobExecutor(Group.CYPHER_CACHE);
        ExecutorBasedCaffeineCacheFactory cacheFactory = new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
        FabricPlanner planner = this.register(new FabricPlanner(this.fabricConfig, cypherConfig, monitors, (CaffeineCacheFactory)cacheFactory), FabricPlanner.class);
        UseEvaluation useEvaluation = this.register(new UseEvaluation(), UseEvaluation.class);
        this.register(new FabricReactorHooksService(errorReporter), FabricReactorHooksService.class);
        CallableExecutor fabricWorkerExecutor = jobScheduler.executor(Group.FABRIC_WORKER);
        FabricExecutor fabricExecutor = new FabricExecutor(this.fabricConfig, planner, useEvaluation, internalLogProvider, statementLifecycles, (Executor)fabricWorkerExecutor);
        this.register(fabricExecutor, FabricExecutor.class);
    }

    protected DatabaseLookup createDatabaseLookup(FabricDatabaseManager fabricDatabaseManager) {
        return new DatabaseLookup.Default(fabricDatabaseManager);
    }

    public BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider() {
        FabricExecutor fabricExecutor = (FabricExecutor)this.dependencies.resolveDependency(FabricExecutor.class);
        TransactionManager transactionManager = (TransactionManager)((Object)this.dependencies.resolveDependency(TransactionManager.class));
        FabricDatabaseManager fabricDatabaseManager = (FabricDatabaseManager)this.dependencies.resolveDependency(FabricDatabaseManager.class);
        LocalGraphTransactionIdTracker localGraphTransactionIdTracker = (LocalGraphTransactionIdTracker)this.dependencies.resolveDependency(LocalGraphTransactionIdTracker.class);
        BoltFabricDatabaseManagementService boltFabricDatabaseManagementService = new BoltFabricDatabaseManagementService(fabricExecutor, this.fabricConfig, transactionManager, fabricDatabaseManager, localGraphTransactionIdTracker);
        return (BoltGraphDatabaseManagementServiceSPI)this.dependencies.satisfyDependency((Object)boltFabricDatabaseManagementService);
    }

    protected abstract FabricDatabaseManager createFabricDatabaseManager(FabricConfig var1);

    protected abstract CatalogManager createCatalogManger(FabricDatabaseManager var1);

    protected abstract FabricRemoteExecutor bootstrapRemoteStack();

    protected abstract FabricConfig bootstrapFabricConfig(boolean var1);

    private record ServiceBootstrapper(LifeSupport lifeSupport, Dependencies dependencies) {
        <T> T registerService(T dependency, Class<T> dependencyType) {
            this.dependencies.satisfyDependency(dependency);
            if (LifecycleAdapter.class.isAssignableFrom(dependencyType)) {
                this.lifeSupport.add((Lifecycle)((LifecycleAdapter)dependency));
            }
            return (T)this.dependencies.resolveDependency(dependencyType);
        }
    }

    public static class Community
    extends FabricServicesBootstrap {
        public Community(LifeSupport lifeSupport, Dependencies dependencies, LogService logService, DatabaseContextProvider<? extends DatabaseContext> databaseProvider, DatabaseReferenceRepository databaseReferenceRepo) {
            super(lifeSupport, dependencies, logService, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG, databaseProvider, databaseReferenceRepo, false);
        }

        @Override
        protected FabricDatabaseManager createFabricDatabaseManager(FabricConfig fabricConfig) {
            return new FabricDatabaseManager(fabricConfig, (DatabaseContextProvider<? extends DatabaseContext>)this.databaseProvider, this.databaseReferenceRepo);
        }

        @Override
        protected CatalogManager createCatalogManger(FabricDatabaseManager fabricDatabaseManager) {
            return new CommunityCatalogManager(this.createDatabaseLookup(fabricDatabaseManager), this::getSystemDbTransactionIdStore);
        }

        private TransactionIdStore getSystemDbTransactionIdStore() {
            return (TransactionIdStore)this.databaseProvider.getSystemDatabaseContext().dependencies().resolveDependency(TransactionIdStore.class);
        }

        @Override
        protected FabricRemoteExecutor bootstrapRemoteStack() {
            return new ThrowingFabricRemoteExecutor();
        }

        @Override
        protected FabricConfig bootstrapFabricConfig(boolean isFallback) {
            Config config = this.resolve(Config.class);
            return FabricConfig.from(config);
        }
    }
}

